/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Follower;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.monsters.ood.OodColour;
import me.eccentric_nz.tardisweepingangels.utils.Monster;

public class ResultSetFollowers {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final String uuid;
    private Follower follower;

    public ResultSetFollowers(TARDIS plugin, String uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT * FROM " + this.prefix + "followers WHERE uuid = ?";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, this.uuid);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                UUID owner = TARDISWeepingAngels.UNCLAIMED;
                String o = rs.getString("owner");
                if (!o.isEmpty()) {
                    owner = UUID.fromString(o);
                }
                OodColour colour = OodColour.BLACK;
                String c = rs.getString("colour");
                if (!c.isEmpty()) {
                    colour = OodColour.valueOf(c);
                }
                this.follower = new Follower(UUID.fromString(rs.getString("uuid")), owner, Monster.valueOf(rs.getString("species")), rs.getBoolean("following"), rs.getBoolean("option"), colour, rs.getInt("ammo"));
                boolean bl = true;
                return bl;
            }
            boolean owner = false;
            return owner;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for followers table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing followers table! " + e.getMessage());
            }
        }
    }

    public Follower getEntity() {
        return this.follower;
    }
}

