/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class ResultSetForcefield {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String where;
    private final String prefix;
    private UUID uuid;
    private Location location;

    public ResultSetForcefield(TARDIS plugin, String where) {
        this.plugin = plugin;
        this.where = where;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        World world;
        block20: {
            Statement statement = null;
            ResultSet rs = null;
            String currentTable = this.prefix + "current";
            String tardisTable = this.prefix + "tardis";
            String query = String.format("SELECT %s.uuid, %s.* FROM %s, %s WHERE %s.uuid = ? AND %s.tardis_id = %s.tardis_id", tardisTable, currentTable, tardisTable, currentTable, tardisTable, tardisTable, currentTable);
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.where);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    rs.next();
                    this.uuid = UUID.fromString(rs.getString("uuid"));
                    world = TARDISAliasResolver.getWorldFromAlias(rs.getString("world"));
                    int x = rs.getInt("x");
                    int y = rs.getInt("y");
                    int z = rs.getInt("z");
                    this.location = new Location(world, (double)x, (double)y, (double)z);
                    if (this.plugin.getTardisArea().isInExistingArea(this.location)) {
                        this.plugin.getMessenger().send((CommandSender)this.plugin.getServer().getPlayer(this.uuid), TardisModule.TARDIS, "FORCE_FIELD_IN_AREA");
                        boolean bl = false;
                        return bl;
                    }
                    break block20;
                }
                boolean x = false;
                return x;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for forcefield query! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing forcefield query! " + e.getMessage());
                }
            }
        }
        return world != null;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Location getLocation() {
        return this.location;
    }
}

