/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetLibrary {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String location;
    private final String prefix;

    public ResultSetLibrary(TARDIS plugin, String location) {
        this.plugin = plugin;
        this.location = location;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT * FROM " + this.prefix + "vaults WHERE location = ? AND chest_type = 'LIBRARY'";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, this.location);
            rs = statement.executeQuery();
            boolean bl = rs.isBeforeFirst();
            return bl;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for [vaults] library table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing [vaults] library table! " + e.getMessage());
            }
        }
    }
}

