/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetPaperBag {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final UUID uuid;
    private final List<Integer> flavours = new ArrayList<Integer>(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)));
    private final String prefix;
    private int paperBagID;
    private String flavour1;
    private int amount1;
    private String flavour2;
    private int amount2;
    private String flavour3;
    private int amount3;
    private String flavour4;
    private int amount4;

    public ResultSetPaperBag(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block16: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "paper_bag WHERE uuid = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.uuid.toString());
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    rs.next();
                    this.paperBagID = rs.getInt("paper_bag_id");
                    this.flavour1 = rs.getString("flavour_1");
                    this.amount1 = rs.getInt("amount_1");
                    this.flavour2 = rs.getString("flavour_2");
                    this.amount2 = rs.getInt("amount_2");
                    this.flavour3 = rs.getString("flavour_3");
                    this.amount3 = rs.getInt("amount_3");
                    this.flavour4 = rs.getString("flavour_4");
                    this.amount4 = rs.getInt("amount_4");
                    break block16;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for paper_bag table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing paper_bag table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJellyBaby() {
        block20: {
            Statement statement = null;
            Statement ps = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "paper_bag WHERE uuid = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.uuid.toString());
                rs = statement.executeQuery();
                if (!rs.isBeforeFirst()) break block20;
                rs.next();
                Collections.shuffle(this.flavours);
                for (int f : this.flavours) {
                    int amount = rs.getInt("amount_" + f);
                    if (amount <= 0) continue;
                    String update = "UPDATE " + this.prefix + "paper_bag set amount_" + f + " = ? WHERE uuid = ?";
                    ps = this.connection.prepareStatement(update);
                    ps.setInt(1, amount - 1);
                    ps.setString(2, this.uuid.toString());
                    ps.executeUpdate();
                    String string = rs.getString("flavour_" + f);
                    return string;
                }
                Iterator<Integer> iterator = null;
                return iterator;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for paper_bag table! " + e.getMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing paper_bag table! " + e.getMessage());
                }
            }
        }
        return null;
    }

    public int getPaperBagID() {
        return this.paperBagID;
    }

    public String getFlavour1() {
        return this.flavour1;
    }

    public int getAmount1() {
        return this.amount1;
    }

    public String getFlavour2() {
        return this.flavour2;
    }

    public int getAmount2() {
        return this.amount2;
    }

    public String getFlavour3() {
        return this.flavour3;
    }

    public int getAmount3() {
        return this.amount3;
    }

    public String getFlavour4() {
        return this.flavour4;
    }

    public int getAmount4() {
        return this.amount4;
    }
}

