/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetTravellers {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final boolean multiple;
    private final List<UUID> data = new ArrayList<UUID>();
    private final String prefix;
    private int traveller_id;
    private int tardis_id;

    public ResultSetTravellers(TARDIS plugin, HashMap<String, Object> where, boolean multiple) {
        this.plugin = plugin;
        this.where = where;
        this.multiple = multiple;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block23: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            String query = "SELECT * FROM " + this.prefix + "travellers" + (String)wheres;
            try {
                int s;
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String || entry.getValue() instanceof UUID) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        if (this.multiple) {
                            this.data.add(UUID.fromString(rs.getString("uuid")));
                        }
                        this.traveller_id = rs.getInt("traveller_id");
                        this.tardis_id = rs.getInt("tardis_id");
                    }
                    break block23;
                }
                s = 0;
                return s != 0;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for travellers table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing travellers table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getTraveller_id() {
        return this.traveller_id;
    }

    public int getTardis_id() {
        return this.tardis_id;
    }

    public List<UUID> getData() {
        return Collections.unmodifiableList(this.data);
    }
}

