/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetVault {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String where;
    private final int id;
    private final String prefix;
    private int vault_id;
    private int tardis_id;
    private String location;
    private int x;
    private int y;
    private int z;

    public ResultSetVault(TARDIS plugin, String where) {
        this.plugin = plugin;
        this.where = where;
        this.id = -1;
        this.prefix = this.plugin.getPrefix();
    }

    public ResultSetVault(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.where = "";
        this.id = id;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block19: {
            Statement statement = null;
            ResultSet rs = null;
            String query = this.where.isEmpty() ? "SELECT * FROM " + this.prefix + "vaults WHERE tardis_id = ?" : "SELECT * FROM " + this.prefix + "vaults WHERE location = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where.isEmpty()) {
                    statement.setInt(1, this.id);
                } else {
                    statement.setString(1, this.where);
                }
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        this.vault_id = rs.getInt("v_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.location = rs.getString("location");
                        this.x = rs.getInt("x");
                        this.y = rs.getInt("y");
                        this.z = rs.getInt("z");
                    }
                    break block19;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for vaults table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing vaults table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getVault_id() {
        return this.vault_id;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }
}

