/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.desktop.PreviewData;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class TARDISPreviewPersister {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private int count = 0;

    public TARDISPreviewPersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (!this.plugin.getTrackerKeeper().getPreviewers().isEmpty()) {
            Statement ps = null;
            try {
                this.connection.setAutoCommit(false);
                ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "previewers (uuid, world, x, y, z, yaw, pitch, gamemode) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                for (Map.Entry<UUID, PreviewData> entry : this.plugin.getTrackerKeeper().getPreviewers().entrySet()) {
                    ps.setString(1, entry.getKey().toString());
                    Location location = entry.getValue().location();
                    GameMode gameMode = entry.getValue().gamemode();
                    ps.setString(2, location.getWorld().getName());
                    ps.setDouble(3, location.getX());
                    ps.setDouble(4, location.getY());
                    ps.setDouble(5, location.getZ());
                    ps.setFloat(6, location.getYaw());
                    ps.setFloat(7, location.getPitch());
                    ps.setString(8, gameMode.toString());
                    ps.addBatch();
                    ++this.count;
                }
                ps.executeBatch();
                this.connection.setAutoCommit(true);
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.count + " desktop previewers.");
            }
            catch (SQLException e) {
                this.plugin.debug("Insert error for previewers query: " + e.getMessage());
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing previewers statement: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Statement ps = null;
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT * FROM " + this.prefix + "previewers";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    try {
                        UUID uuid = UUID.fromString(rs.getString("uuid"));
                        String world = rs.getString("world");
                        float x = rs.getFloat("x");
                        float y = rs.getFloat("y");
                        float z = rs.getFloat("z");
                        float yaw = rs.getFloat("yaw");
                        float pitch = rs.getFloat("pitch");
                        Location location = new Location(TARDISAliasResolver.getWorldFromAlias(world), (double)x, (double)y, (double)z, yaw, pitch);
                        String gm = rs.getString("gamemode");
                        GameMode gamemode = GameMode.valueOf((String)gm);
                        int id = rs.getInt("tardis_id");
                        this.plugin.getTrackerKeeper().getPreviewers().put(uuid, new PreviewData(location, gamemode, id));
                    }
                    catch (IllegalArgumentException uuid) {}
                }
            }
            ps = this.connection.prepareStatement("DELETE FROM " + this.prefix + "previewers");
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for previewers table! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing previewers table! " + e.getMessage());
            }
        }
    }
}

