/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.rooms.TARDISWalls;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TARDISWallListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    protected final HashMap<UUID, Integer> scroll = new HashMap();
    protected final List<UUID> scrolling = new ArrayList<UUID>();
    private final ItemStack[][] blocks;
    private final int rows;

    public TARDISWallListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.rows = TARDISWalls.BLOCKS.size() / 8 + 1;
        this.blocks = this.getWallBlocks();
    }

    protected String getWallFloor(UUID uuid, boolean wall) {
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
        if (rsp.resultSet()) {
            return wall ? rsp.getWall() : rsp.getFloor();
        }
        return wall ? "ORANGE_WOOL" : "LIGHT_GRAY_WOOL";
    }

    protected void close(Player p, boolean remove) {
        if (remove) {
            this.plugin.getTrackerKeeper().getUpgrades().remove(p.getUniqueId());
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((Player)p).closeInventory(), 1L);
    }

    protected void scroll(InventoryView view, int row, boolean up, UUID uuid) {
        if (up && row < this.rows - 5 || !up && row >= 0) {
            this.scroll.put(uuid, row);
            this.setSlots(view, row, uuid);
        } else {
            this.scrolling.remove(uuid);
        }
    }

    private void setSlots(InventoryView view, int row, UUID uuid) {
        int slot = 0;
        for (int r = row; r < row + 6; ++r) {
            for (int c = 0; c < 8; ++c) {
                view.setItem(slot, this.blocks[r][c]);
                if (slot % 9 == 7) {
                    slot += 2;
                    continue;
                }
                ++slot;
            }
        }
        this.scrolling.remove(uuid);
    }

    protected ItemStack[][] getWallBlocks() {
        ItemStack[][] stacks = new ItemStack[this.rows][8];
        int r = 0;
        int c = 0;
        for (Material entry : TARDISWalls.BLOCKS) {
            ItemStack is;
            stacks[r][c] = is = ItemStack.of((Material)entry, (int)1);
            if (++c != 8) continue;
            ++r;
            c = 0;
        }
        return stacks;
    }
}

