/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.doors.inner;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.custommodels.keys.BoneDoorVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ClassicDoorVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.TardisDoorVariant;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetOuterPortal;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.doors.Door;
import me.eccentric_nz.TARDIS.doors.DoorAnimator;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InnerDisplayDoorOpener {
    private final TARDIS plugin;

    public InnerDisplayDoorOpener(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void open(Block block, int id, boolean outside) {
        block26: {
            TARDISDisplayItem tdi;
            ItemDisplay display = TARDISDisplayItemUtils.getFromBoundingBox(block);
            if (display == null || (tdi = TARDISDisplayItemUtils.get(display)) == null) break block26;
            if (outside) {
                ItemStack itemStack = display.getItemStack();
                ItemMeta im = itemStack.getItemMeta();
                switch (itemStack.getType()) {
                    case IRON_DOOR: {
                        im.setItemModel(TardisDoorVariant.TARDIS_DOOR_OPEN.getKey());
                        break;
                    }
                    case BIRCH_DOOR: {
                        im.setItemModel(BoneDoorVariant.BONE_DOOR_OPEN.getKey());
                        break;
                    }
                    case CHERRY_DOOR: {
                        im.setItemModel(ClassicDoorVariant.CLASSIC_DOOR_OPEN.getKey());
                        break;
                    }
                    default: {
                        im.setItemModel(Door.getOpenModel(itemStack.getType()));
                    }
                }
                itemStack.setItemMeta(im);
                display.setItemStack(itemStack);
            } else {
                new DoorAnimator(this.plugin, display).animate(false);
            }
            if (!this.plugin.getTrackerKeeper().getWoolToggles().contains(id)) {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", id);
                ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                if (rs.resultSet()) {
                    Tardis tardis = rs.getTardis();
                    ChameleonPreset preset = tardis.getPreset();
                    Location portal = block.getLocation();
                    ResultSetOuterPortal resultSetPortal = new ResultSetOuterPortal(this.plugin, id);
                    if (resultSetPortal.resultSet()) {
                        Location teleport = resultSetPortal.getLocation().clone();
                        if (preset.usesArmourStand() || preset == ChameleonPreset.INVISIBLE) {
                            switch (resultSetPortal.getDirection()) {
                                case NORTH_EAST: {
                                    teleport.add(0.0, 0.0, 1.0);
                                    break;
                                }
                                case NORTH: {
                                    teleport.add(0.5, 0.0, 1.0);
                                    break;
                                }
                                case NORTH_WEST: {
                                    teleport.add(1.0, 0.0, 1.0);
                                    break;
                                }
                                case WEST: {
                                    teleport.add(1.0, 0.0, 0.5);
                                    break;
                                }
                                case SOUTH_WEST: {
                                    teleport.add(1.0, 0.0, -0.5);
                                    break;
                                }
                                case SOUTH: {
                                    teleport.add(0.5, 0.0, -1.0);
                                    break;
                                }
                                case SOUTH_EAST: {
                                    teleport.add(-0.5, 0.0, 0.0);
                                    break;
                                }
                                default: {
                                    teleport.add(-1.0, 0.0, 0.5);
                                    break;
                                }
                            }
                        } else {
                            teleport.setX(teleport.getX() + 0.5);
                            teleport.setZ(teleport.getZ() + 0.5);
                        }
                        TARDISTeleportLocation tp_out = new TARDISTeleportLocation();
                        tp_out.setLocation(teleport);
                        tp_out.setTardisId(id);
                        tp_out.setDirection(resultSetPortal.getDirection());
                        tp_out.setAbandoned(tardis.isAbandoned());
                        this.plugin.getTrackerKeeper().getPortals().put(portal, tp_out);
                        if (!this.plugin.getConfig().getBoolean("preferences.open_door_policy")) {
                            this.plugin.getTrackerKeeper().getMovers().add(tardis.getUuid());
                            if (tardis.getCompanions().equalsIgnoreCase("everyone")) {
                                for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                                    this.plugin.getTrackerKeeper().getMovers().add(p.getUniqueId());
                                }
                            } else {
                                String[] companions;
                                for (String c : companions = tardis.getCompanions().split(":")) {
                                    if (c.isEmpty()) continue;
                                    this.plugin.getTrackerKeeper().getMovers().add(UUID.fromString(c));
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

