/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.enumeration;

import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import org.bukkit.Material;

public enum TardisLight {
    BULB(TARDISDisplayItem.LIGHT_BULB_ON, TARDISDisplayItem.LIGHT_BULB, TARDISDisplayItem.LIGHT_BULB_CLOISTER),
    CLASSIC(TARDISDisplayItem.LIGHT_CLASSIC_ON, TARDISDisplayItem.LIGHT_CLASSIC, TARDISDisplayItem.LIGHT_CLASSIC_CLOISTER),
    CLASSIC_OFFSET(TARDISDisplayItem.LIGHT_CLASSIC_OFFSET_ON, TARDISDisplayItem.LIGHT_CLASSIC_OFFSET, TARDISDisplayItem.LIGHT_CLASSIC_OFFSET_CLOISTER),
    TENTH(Material.REDSTONE_LAMP, TARDISDisplayItem.LIGHT_TENTH_ON, TARDISDisplayItem.LIGHT_TENTH, TARDISDisplayItem.LIGHT_TENTH_CLOISTER),
    ELEVENTH(TARDISDisplayItem.LIGHT_ELEVENTH_ON, TARDISDisplayItem.LIGHT_ELEVENTH, TARDISDisplayItem.LIGHT_ELEVENTH_CLOISTER),
    TWELFTH(TARDISDisplayItem.LIGHT_TWELFTH_ON, TARDISDisplayItem.LIGHT_TWELFTH, TARDISDisplayItem.LIGHT_TWELFTH_CLOISTER),
    THIRTEENTH(TARDISDisplayItem.LIGHT_THIRTEENTH_ON, TARDISDisplayItem.LIGHT_THIRTEENTH, TARDISDisplayItem.LIGHT_THIRTEENTH_CLOISTER),
    LAMP(Material.REDSTONE_LAMP, TARDISDisplayItem.LIGHT_LAMP_ON, TARDISDisplayItem.LIGHT_LAMP),
    LANTERN(TARDISDisplayItem.LIGHT_LANTERN_ON, TARDISDisplayItem.LIGHT_LANTERN),
    BLUE_LAMP(TARDISDisplayItem.BLUE_LAMP_ON, TARDISDisplayItem.BLUE_LAMP),
    GREEN_LAMP(TARDISDisplayItem.GREEN_LAMP_ON, TARDISDisplayItem.GREEN_LAMP),
    PURPLE_LAMP(TARDISDisplayItem.PURPLE_LAMP_ON, TARDISDisplayItem.PURPLE_LAMP),
    RED_LAMP(TARDISDisplayItem.RED_LAMP_ON, TARDISDisplayItem.RED_LAMP),
    VARIABLE(TARDISDisplayItem.LIGHT_VARIABLE_ON, TARDISDisplayItem.LIGHT_VARIABLE),
    VARIABLE_BLUE(TARDISDisplayItem.LIGHT_VARIABLE_BLUE_ON, TARDISDisplayItem.LIGHT_VARIABLE_BLUE),
    VARIABLE_GREEN(TARDISDisplayItem.LIGHT_VARIABLE_GREEN_ON, TARDISDisplayItem.LIGHT_VARIABLE_GREEN),
    VARIABLE_ORANGE(TARDISDisplayItem.LIGHT_VARIABLE_ORANGE_ON, TARDISDisplayItem.LIGHT_VARIABLE_ORANGE),
    VARIABLE_PINK(TARDISDisplayItem.LIGHT_VARIABLE_PINK_ON, TARDISDisplayItem.LIGHT_VARIABLE_PINK),
    VARIABLE_PURPLE(TARDISDisplayItem.LIGHT_VARIABLE_PURPLE_ON, TARDISDisplayItem.LIGHT_VARIABLE_PURPLE),
    VARIABLE_RED(TARDISDisplayItem.LIGHT_VARIABLE_CLOISTER, TARDISDisplayItem.LIGHT_VARIABLE),
    VARIABLE_YELLOW(TARDISDisplayItem.LIGHT_VARIABLE_YELLOW_ON, TARDISDisplayItem.LIGHT_VARIABLE_YELLOW);

    private final Material material;
    private final TARDISDisplayItem on;
    private final TARDISDisplayItem off;
    private final TARDISDisplayItem cloister;

    private TardisLight(TARDISDisplayItem on, TARDISDisplayItem off, TARDISDisplayItem cloister) {
        this.material = Material.SEA_LANTERN;
        this.on = on;
        this.off = off;
        this.cloister = cloister;
    }

    private TardisLight(TARDISDisplayItem on, TARDISDisplayItem off) {
        this.material = Material.SEA_LANTERN;
        this.on = on;
        this.off = off;
        this.cloister = TARDISDisplayItem.NONE;
    }

    private TardisLight(Material material, TARDISDisplayItem on, TARDISDisplayItem off) {
        this.material = material;
        this.on = on;
        this.off = off;
        this.cloister = TARDISDisplayItem.NONE;
    }

    private TardisLight(Material material, TARDISDisplayItem on, TARDISDisplayItem off, TARDISDisplayItem cloister) {
        this.material = material;
        this.on = on;
        this.off = off;
        this.cloister = cloister;
    }

    public static TARDISDisplayItem getToggled(TARDISDisplayItem tdi) {
        for (TardisLight light : TardisLight.values()) {
            if (light.getOff() == tdi) {
                return light.getOn();
            }
            if (light.getOn() != tdi) continue;
            return light.getOff();
        }
        return null;
    }

    public static TardisLight getFromDisplayItem(TARDISDisplayItem tdi) {
        String s = tdi.toString();
        return switch (tdi) {
            case TARDISDisplayItem.RED_LAMP, TARDISDisplayItem.GREEN_LAMP, TARDISDisplayItem.PURPLE_LAMP, TARDISDisplayItem.BLUE_LAMP -> TardisLight.valueOf(s);
            case TARDISDisplayItem.RED_LAMP_ON, TARDISDisplayItem.GREEN_LAMP_ON, TARDISDisplayItem.PURPLE_LAMP_ON, TARDISDisplayItem.BLUE_LAMP_ON -> TardisLight.valueOf(s.substring(0, s.length() - 3));
            case TARDISDisplayItem.LIGHT_BULB, TARDISDisplayItem.LIGHT_CLASSIC, TARDISDisplayItem.LIGHT_CLASSIC_OFFSET, TARDISDisplayItem.LIGHT_TENTH, TARDISDisplayItem.LIGHT_ELEVENTH, TARDISDisplayItem.LIGHT_TWELFTH, TARDISDisplayItem.LIGHT_THIRTEENTH, TARDISDisplayItem.LIGHT_LAMP, TARDISDisplayItem.LIGHT_LANTERN, TARDISDisplayItem.LIGHT_VARIABLE -> TardisLight.valueOf(s.substring(6));
            case TARDISDisplayItem.LIGHT_BULB_ON, TARDISDisplayItem.LIGHT_CLASSIC_ON, TARDISDisplayItem.LIGHT_CLASSIC_OFFSET_ON, TARDISDisplayItem.LIGHT_TENTH_ON, TARDISDisplayItem.LIGHT_ELEVENTH_ON, TARDISDisplayItem.LIGHT_TWELFTH_ON, TARDISDisplayItem.LIGHT_THIRTEENTH_ON, TARDISDisplayItem.LIGHT_LAMP_ON, TARDISDisplayItem.LIGHT_LANTERN_ON, TARDISDisplayItem.LIGHT_VARIABLE_ON, TARDISDisplayItem.LIGHT_VARIABLE_BLUE_ON, TARDISDisplayItem.LIGHT_VARIABLE_GREEN_ON, TARDISDisplayItem.LIGHT_VARIABLE_ORANGE_ON, TARDISDisplayItem.LIGHT_VARIABLE_PINK_ON, TARDISDisplayItem.LIGHT_VARIABLE_PURPLE_ON, TARDISDisplayItem.LIGHT_VARIABLE_YELLOW_ON -> TardisLight.valueOf(s.substring(6, s.length() - 3));
            default -> TENTH;
        };
    }

    public Material getMaterial() {
        return this.material;
    }

    public TARDISDisplayItem getOn() {
        return this.on;
    }

    public TARDISDisplayItem getOff() {
        return this.off;
    }

    public TARDISDisplayItem getCloister() {
        return this.cloister;
    }
}

