/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.files;

import java.io.File;
import java.io.IOException;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class TARDISAllInOneConfigConverter {
    private final TARDIS plugin;
    private final String basePath;

    public TARDISAllInOneConfigConverter(TARDIS plugin) {
        this.plugin = plugin;
        this.basePath = String.valueOf(this.plugin.getServer().getWorldContainer()) + File.separator + "plugins" + File.separator;
    }

    public boolean transferConfig(TardisModule module) {
        try {
            switch (module) {
                case HELPER: {
                    String tcgPath = this.basePath + "TARDISChunkGenerator" + File.separator + "config.yml";
                    File tcgFile = new File(tcgPath);
                    if (!tcgFile.exists()) break;
                    YamlConfiguration tcg = YamlConfiguration.loadConfiguration((File)tcgFile);
                    FileConfiguration flat = this.plugin.getGeneratorConfig();
                    for (String key : flat.getKeys(false)) {
                        flat.set(key, tcg.get(key));
                    }
                    String flatPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "generator.yml";
                    File hf = new File(flatPath);
                    flat.save(hf);
                    this.plugin.getGeneratorConfig().load(hf);
                    break;
                }
                case VORTEX_MANIPULATOR: {
                    String vmPath = this.basePath + "TARDISVortexManipulator" + File.separator + "config.yml";
                    File vmFile = new File(vmPath);
                    if (!vmFile.exists()) break;
                    YamlConfiguration vm = YamlConfiguration.loadConfiguration((File)vmFile);
                    FileConfiguration vortex = this.plugin.getVortexConfig();
                    for (String key : vortex.getKeys(true)) {
                        vortex.set(key, vm.get(key));
                    }
                    String vortexPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "vortex_manipulator.yml";
                    File vf = new File(vortexPath);
                    vortex.save(vf);
                    this.plugin.getVortexConfig().load(vf);
                    break;
                }
                case MONSTERS: {
                    String twaPath = this.basePath + "TARDISWeepingAngels" + File.separator + "config.yml";
                    File twaFile = new File(twaPath);
                    if (!twaFile.exists()) break;
                    YamlConfiguration twa = YamlConfiguration.loadConfiguration((File)twaFile);
                    FileConfiguration monsters = this.plugin.getMonstersConfig();
                    for (String key : monsters.getKeys(true)) {
                        monsters.set(key, twa.get(key));
                    }
                    String monstersPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "monsters.yml";
                    File mf = new File(monstersPath);
                    monsters.save(mf);
                    this.plugin.getMonstersConfig().load(mf);
                    break;
                }
                case SHOP: {
                    String tsiPath;
                    File tsiFile;
                    String tsPath = this.basePath + "TARDISShop" + File.separator + "config.yml";
                    File tsFile = new File(tsPath);
                    if (tsFile.exists()) {
                        YamlConfiguration ts = YamlConfiguration.loadConfiguration((File)tsFile);
                        FileConfiguration shop = this.plugin.getShopConfig();
                        for (String key : shop.getKeys(true)) {
                            shop.set(key, ts.get(key));
                        }
                        String shopPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "shop.yml";
                        File sf = new File(shopPath);
                        shop.save(sf);
                        this.plugin.getShopConfig().load(sf);
                    }
                    if (!(tsiFile = new File(tsiPath = this.basePath + "TARDISShop" + File.separator + "items.yml")).exists()) break;
                    YamlConfiguration tsi = YamlConfiguration.loadConfiguration((File)tsiFile);
                    FileConfiguration items = this.plugin.getItemsConfig();
                    for (String key : items.getKeys(true)) {
                        items.set(key, tsi.get(key));
                    }
                    String itemPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "items.yml";
                    File itf = new File(itemPath);
                    items.save(itf);
                    this.plugin.getItemsConfig().load(itf);
                    break;
                }
                case BLASTER: {
                    String tbPath = this.basePath + "TARDISSonicBlaster" + File.separator + "config.yml";
                    File tbFile = new File(tbPath);
                    if (!tbFile.exists()) break;
                    YamlConfiguration ts = YamlConfiguration.loadConfiguration((File)tbFile);
                    FileConfiguration blaster = this.plugin.getBlasterConfig();
                    blaster.set("max_blocks", ts.get("max_blocks"));
                    for (String key : blaster.getConfigurationSection("tachyon_use").getKeys(false)) {
                        blaster.set("tachyon_use." + key, ts.get("tachyon_use." + key));
                    }
                    String rbPath = this.basePath + "TARDISSonicBlaster" + File.separator + "recipes.yml";
                    File rbFile = new File(rbPath);
                    if (rbFile.exists()) {
                        YamlConfiguration rs = YamlConfiguration.loadConfiguration((File)rbFile);
                        for (String key : blaster.getConfigurationSection("recipes").getKeys(true)) {
                            blaster.set("recipes." + key, rs.get(key));
                        }
                    }
                    String blasterPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "blaster.yml";
                    File bf = new File(blasterPath);
                    blaster.save(bf);
                    this.plugin.getBlasterConfig().load(bf);
                    break;
                }
            }
            return true;
        }
        catch (IOException | InvalidConfigurationException e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, "Could not transfer config options from " + String.valueOf((Object)module) + " legacy plugin folder! " + e.getMessage());
            return false;
        }
    }
}

