/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.flight.FlightReturnData;
import me.eccentric_nz.TARDIS.flight.vehicle.InterpolatedAnimation;
import me.eccentric_nz.TARDIS.flight.vehicle.VehicleUtility;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class FlightVisibility {
    private final TARDIS plugin;

    public FlightVisibility(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void hide(ArmorStand stand, Player player) {
        ItemDisplay display = (ItemDisplay)player.getPassengers().getFirst();
        ItemStack head = display.getItemStack();
        this.plugin.getTrackerKeeper().getHiddenFlight().put(player.getUniqueId(), head);
        FlightReturnData frd = this.plugin.getTrackerKeeper().getFlyingReturnLocation().get(player.getUniqueId());
        this.plugin.getServer().getScheduler().cancelTask(frd.animation());
        player.eject();
        display.remove();
        if (stand.customName() != null) {
            stand.setCustomNameVisible(false);
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 15));
    }

    public void show(Player player) {
        FlightReturnData frd = this.plugin.getTrackerKeeper().getFlyingReturnLocation().get(player.getUniqueId());
        UUID uuid = frd.stand();
        Entity as = this.plugin.getServer().getEntity(uuid);
        if (as instanceof ArmorStand) {
            ArmorStand stand = (ArmorStand)as;
            if (stand.customName() != null) {
                stand.setCustomNameVisible(true);
            }
            player.removePotionEffect(PotionEffectType.INVISIBILITY);
            ItemStack box = this.plugin.getTrackerKeeper().getHiddenFlight().get(player.getUniqueId());
            ItemDisplay display = VehicleUtility.getItemDisplay(player, box, switch (box.getType()) {
                case Material.ENDER_PEARL -> 1.5f;
                case Material.GRAY_STAINED_GLASS_PANE -> 1.66f;
                default -> 1.75f;
            });
            int animation = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new InterpolatedAnimation(display, 40), 5L, 40L);
            this.plugin.getTrackerKeeper().getFlyingReturnLocation().put(player.getUniqueId(), new FlightReturnData(frd.id(), frd.location(), frd.sound(), animation, stand.getUniqueId(), display.getUniqueId()));
            this.plugin.getTrackerKeeper().getHiddenFlight().remove(player.getUniqueId());
        }
    }
}

