/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.companionGUI.TARDISCompanionGUIListener;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.FloodgateAddCompanionsForm;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateCompanionsForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final String[] companionData;
    private final String url = "https://raw.githubusercontent.com/eccentricdevotion/TARDIS-Resource-Pack/master/assets/tardis/textures/item/gui/%s.png";
    private final String[] heads = new String[2];

    public FloodgateCompanionsForm(TARDIS plugin, UUID uuid, String[] companionData) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.companionData = companionData;
        this.heads[0] = "alex";
        this.heads[1] = "steve";
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("TARDIS Companions Menu");
        builder.content("To REMOVE a companion select a player button. To add a companion, select the Add button.");
        int i = 0;
        for (String c : this.companionData) {
            OfflinePlayer op;
            if (c.isEmpty() || (op = this.plugin.getServer().getOfflinePlayer(UUID.fromString(c))) == null) continue;
            builder.button(op.getName(), FormImage.Type.URL, String.format("https://raw.githubusercontent.com/eccentricdevotion/TARDIS-Resource-Pack/master/assets/tardis/textures/item/gui/%s.png", this.heads[i % 2]));
            ++i;
        }
        builder.button("Add");
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        String label = response.clickedButton().text();
        if (label.equals("Add")) {
            new FloodgateAddCompanionsForm(this.plugin, this.uuid).send();
        } else {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", this.uuid.toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                int id = tardis.getTardisId();
                String comps = tardis.getCompanions();
                OfflinePlayer op = this.plugin.getServer().getOfflinePlayer(label);
                if (op != null) {
                    UUID u = op.getUniqueId();
                    TARDISCompanionGUIListener.removeCompanion(id, comps, u.toString(), player);
                    if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard") && !comps.equalsIgnoreCase("everyone")) {
                        String[] data = tardis.getChunk().split(":");
                        TARDISCompanionGUIListener.removeFromRegion(data[0], tardis.getOwner(), u);
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COMPANIONS_REMOVE_ONE", label);
                }
            }
        }
    }
}

