/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.SystemUpgrade;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetSystemUpgrades;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeUpdate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateSystemUpgradesForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final int id;
    private final List<SystemTree> notThese = List.of(SystemTree.UPGRADE_TREE, SystemTree.EXTERIOR_FLIGHT, SystemTree.MONITOR);
    private SystemUpgrade sysData;

    public FloodgateSystemUpgradesForm(TARDIS plugin, UUID uuid, int id) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.id = id;
    }

    public void send() {
        Player p = this.plugin.getServer().getPlayer(this.uuid);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", this.uuid);
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, false);
        if (!rst.resultSet()) {
            return;
        }
        int id = rst.getTardis_id();
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("tardis_id", id);
        wheret.put("uuid", this.uuid.toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
        if (!rs.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "NOT_OWNER");
            return;
        }
        ResultSetSystemUpgrades rsp = new ResultSetSystemUpgrades(this.plugin, id, this.uuid.toString());
        if (!rsp.resultset()) {
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SYS_TRAVEL_FIRST");
            return;
        }
        this.sysData = rsp.getData();
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("TARDIS System Upgrades");
        builder.content("Artron Level: " + this.sysData.getArtronLevel());
        for (SystemTree g : SystemTree.values()) {
            String suffix;
            if (g.getSlot() == -1 || this.notThese.contains((Object)g)) continue;
            boolean has = this.sysData.getUpgrades().get((Object)g);
            boolean branch = g.getBranch().equals("branch");
            String prefix = branch ? String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.ITALIC) : "";
            String image = "sys_locked";
            if (!has) {
                String cost;
                if (branch) {
                    cost = this.plugin.getSystemUpgradesConfig().getString("branch");
                    image = "sys_branch_locked";
                } else {
                    cost = this.plugin.getSystemUpgradesConfig().getString(g.getBranch() + "." + g.toString().toLowerCase(Locale.ROOT));
                }
                suffix = " " + String.valueOf(ChatColor.BLUE) + String.valueOf(ChatColor.ITALIC) + "Cost: " + cost;
            } else {
                suffix = " " + String.valueOf(ChatColor.GREEN) + String.valueOf(ChatColor.ITALIC) + "Unlocked";
                image = branch ? "sys_branch_unlocked" : "sys_unlocked";
            }
            builder.button(prefix + g.getName() + suffix, FormImage.Type.URL, String.format("https://github.com/eccentricdevotion/TARDIS-Resource-Pack/raw/master/assets/tardis/textures/item/circuit/%s.png", image));
        }
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        int button = response.clickedButtonId();
        SystemTree clicked = switch (button) {
            case 0 -> SystemTree.ARCHITECTURE;
            case 1 -> SystemTree.CHAMELEON_CIRCUIT;
            case 2 -> SystemTree.ROOM_GROWING;
            case 3 -> SystemTree.DESKTOP_THEME;
            case 4 -> SystemTree.FEATURE;
            case 5 -> SystemTree.SAVES;
            case 6 -> SystemTree.FORCE_FIELD;
            case 7 -> SystemTree.TOOLS;
            case 8 -> SystemTree.TARDIS_LOCATOR;
            case 9 -> SystemTree.TELEPATHIC_CIRCUIT;
            case 10 -> SystemTree.STATTENHEIM_REMOTE;
            case 11 -> SystemTree.NAVIGATION;
            case 12 -> SystemTree.DISTANCE_1;
            case 13 -> SystemTree.DISTANCE_2;
            case 14 -> SystemTree.DISTANCE_3;
            case 15 -> SystemTree.INTER_DIMENSIONAL_TRAVEL;
            case 16 -> SystemTree.THROTTLE;
            case 17 -> SystemTree.FASTER;
            case 18 -> SystemTree.RAPID;
            case 19 -> SystemTree.WARP;
            default -> SystemTree.UPGRADE_TREE;
        };
        try {
            SystemTree required = SystemTree.valueOf(clicked.getRequired());
            if (!this.sysData.getUpgrades().get((Object)required).booleanValue()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_REQUIRED", required.getName());
                player.playSound(player.getLocation(), Sound.ENTITY_WARDEN_TENDRIL_CLICKS, 1.0f, 1.0f);
            } else {
                if (this.sysData.getUpgrades().get((Object)clicked).booleanValue()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_HAS", clicked.getName());
                    player.playSound(player.getLocation(), Sound.ENTITY_WARDEN_STEP, 1.0f, 1.0f);
                    return;
                }
                int cost = clicked.getBranch().equals("branch") ? this.plugin.getSystemUpgradesConfig().getInt("branch") : this.plugin.getSystemUpgradesConfig().getInt(clicked.getBranch() + "." + clicked.toString().toLowerCase(Locale.ROOT));
                if (cost > this.sysData.getArtronLevel()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_COST", clicked.getName());
                    player.playSound(player.getLocation(), Sound.ENTITY_CAT_EAT, 1.0f, 1.0f);
                    return;
                }
                HashMap<String, Object> wheretl = new HashMap<String, Object>();
                wheretl.put("uuid", this.uuid);
                this.plugin.getQueryFactory().alterEnergyLevel("player_prefs", -cost, wheretl, player);
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_SUCCESS", clicked.getName());
                new SystemUpgradeUpdate(this.plugin).set(this.uuid.toString(), this.id, clicked);
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.debug("IllegalArgumentException for " + clicked.getRequired());
        }
    }
}

