/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.junk;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBlocks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.junk.TARDISJunkItsDangerousRunnable;
import me.eccentric_nz.TARDIS.junk.TARDISJunkVortexRunnable;
import me.eccentric_nz.TARDIS.particles.TARDISParticles;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISJunkDestroyer
implements Runnable {
    private final TARDIS plugin;
    private final DestroyData pdd;
    private final int sx;
    private final int ex;
    private final int sy;
    private final int ey;
    private final int sz;
    private final int ez;
    private final Location junkLoc;
    private final Location effectsLoc;
    private final World world;
    private int task;
    private int i = 0;
    private Location vortexJunkLoc;
    private int fryTask;

    public TARDISJunkDestroyer(TARDIS plugin, DestroyData pdd) {
        this.plugin = plugin;
        this.pdd = pdd;
        this.junkLoc = this.pdd.getLocation();
        this.effectsLoc = this.junkLoc.clone().add(0.5, 0.0, 0.5);
        this.ex = this.junkLoc.getBlockX() + 2;
        this.sx = this.junkLoc.getBlockX() - 3;
        this.sy = this.junkLoc.getBlockY();
        this.ey = this.junkLoc.getBlockY() + 5;
        this.ez = this.junkLoc.getBlockZ() + 3;
        this.sz = this.junkLoc.getBlockZ() - 2;
        this.world = this.junkLoc.getWorld();
    }

    @Override
    public void run() {
        if (this.i < 25) {
            ++this.i;
            if (this.i == 1) {
                if (this.plugin.getConfig().getInt("junk.return") > 0) {
                    this.junkLoc.getChunk().removePluginChunkTicket((Plugin)this.plugin);
                }
                this.getJunkTravellers().forEach(e -> {
                    if (e instanceof Player) {
                        Player p = (Player)e;
                        this.plugin.getGeneralKeeper().getJunkTravellers().add(p.getUniqueId());
                    }
                });
                TARDISSounds.playTARDISSound(this.junkLoc, "junk_takeoff");
                this.fryTask = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new TARDISJunkItsDangerousRunnable(this.plugin, this.junkLoc), 0L, 1L);
            }
            if (this.i == 25) {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", "00000000-aaaa-bbbb-cccc-000000000000");
                ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                if (rs.resultSet()) {
                    this.vortexJunkLoc = TARDISStaticLocationGetters.getLocationFromBukkitString(rs.getTardis().getCreeper()).add(3.0, 0.0, 2.0);
                    this.getJunkTravellers().forEach(e -> {
                        if (e instanceof Player) {
                            Player p = (Player)e;
                            Location relativeLoc = this.getRelativeLocation(p);
                            p.teleport(relativeLoc);
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                                p.teleport(relativeLoc);
                                p.setPlayerTime(18000L, false);
                            }, 2L);
                        }
                    });
                    TARDISJunkVortexRunnable runnable = new TARDISJunkVortexRunnable(this.plugin, this.vortexJunkLoc, this.pdd.getPlayer(), this.pdd.getTardisID());
                    int jvrtask = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 1L, 20L);
                    runnable.setTask(jvrtask);
                }
                for (int level = this.ey; level >= this.sy; --level) {
                    for (int row = this.ex; row >= this.sx; --row) {
                        for (int col = this.sz; col <= this.ez; ++col) {
                            Block block = this.world.getBlockAt(row, level, col);
                            block.setBlockData(TARDISConstants.AIR);
                            TARDISDisplayItemUtils.remove(block);
                        }
                    }
                }
                this.plugin.getTrackerKeeper().getDematerialising().remove(this.pdd.getTardisID());
                this.plugin.getTrackerKeeper().getInVortex().remove(this.pdd.getTardisID());
                HashMap<String, Object> tid = new HashMap<String, Object>();
                tid.put("tardis_id", this.pdd.getTardisID());
                ResultSetBlocks rsb = new ResultSetBlocks(this.plugin, tid, true);
                rsb.resultSetAsync((hasResult, resultSetBlocks) -> {
                    if (hasResult) {
                        resultSetBlocks.getData().forEach(rp -> {
                            int rx = rp.getLocation().getBlockX();
                            int ry = rp.getLocation().getBlockY();
                            int rz = rp.getLocation().getBlockZ();
                            TARDISBlockSetters.setBlock(this.world, rx, ry, rz, rp.getBlockData());
                        });
                    }
                });
                this.plugin.getPresetDestroyer().removeBlockProtection(this.pdd.getTardisID());
                this.plugin.getServer().getScheduler().cancelTask(this.fryTask);
                this.plugin.getServer().getScheduler().cancelTask(this.task);
                this.task = 0;
            } else if (this.plugin.getConfig().getBoolean("junk.particles")) {
                this.plugin.getUtils().getJunkTravellers(this.junkLoc).forEach(e -> {
                    if (e instanceof Player) {
                        Player p = (Player)e;
                        TARDISParticles.sendVortexParticles(this.effectsLoc, p);
                    }
                });
            }
        }
    }

    private Location getRelativeLocation(Player p) {
        Location playerLoc = p.getLocation();
        double x = this.vortexJunkLoc.getX() + (playerLoc.getX() - this.junkLoc.getX());
        double y = this.vortexJunkLoc.getY() + (playerLoc.getY() - this.junkLoc.getY()) + 0.5;
        double z = this.vortexJunkLoc.getZ() + (playerLoc.getZ() - this.junkLoc.getZ());
        Location l = new Location(this.vortexJunkLoc.getWorld(), x, y, z, playerLoc.getYaw(), playerLoc.getPitch());
        while (!l.getChunk().isLoaded()) {
            l.getChunk().load();
        }
        return l;
    }

    private List<Entity> getJunkTravellers() {
        Entity orb = this.junkLoc.getWorld().spawnEntity(this.junkLoc, EntityType.EXPERIENCE_ORB);
        List ents = orb.getNearbyEntities(4.0, 4.0, 4.0);
        orb.remove();
        return ents;
    }

    public void setTask(int task) {
        this.task = task;
    }
}

