/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lazarus.disguise;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ThreadLocalRandom;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.lazarus.disguise.AGE;
import me.eccentric_nz.TARDIS.lazarus.disguise.CARPET;
import me.eccentric_nz.TARDIS.lazarus.disguise.FOX;
import me.eccentric_nz.TARDIS.lazarus.disguise.GENE;
import me.eccentric_nz.TARDIS.lazarus.disguise.MUSHROOM_COW;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftCat;
import org.bukkit.craftbukkit.entity.CraftChicken;
import org.bukkit.craftbukkit.entity.CraftCow;
import org.bukkit.craftbukkit.entity.CraftFrog;
import org.bukkit.craftbukkit.entity.CraftPig;
import org.bukkit.craftbukkit.entity.CraftVillager;
import org.bukkit.craftbukkit.entity.CraftWolf;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Cow;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.ItemStack;

public record TARDISDisguise(org.bukkit.entity.EntityType entityType, Object[] options) {
    public static Entity createMobDisguise(TARDISDisguise disguise, World w) {
        Object str;
        Object packagePath = "net.minecraft.world.entity.";
        boolean hasEntityStr = true;
        switch (disguise.entityType()) {
            case ARMADILLO: {
                str = "Armadillo";
                packagePath = (String)packagePath + "animal.armadillo.";
                hasEntityStr = false;
                break;
            }
            case AXOLOTL: {
                str = "Axolotl";
                packagePath = (String)packagePath + "animal.axolotl.";
                hasEntityStr = false;
                break;
            }
            case ALLAY: {
                str = "Allay";
                packagePath = (String)packagePath + "animal.allay.";
                hasEntityStr = false;
                break;
            }
            case BOGGED: {
                str = "Bogged";
                packagePath = (String)packagePath + "monster.";
                hasEntityStr = false;
                break;
            }
            case BREEZE: {
                str = "Breeze";
                packagePath = (String)packagePath + "monster.breeze.";
                hasEntityStr = false;
                break;
            }
            case CREAKING: {
                str = "Creaking";
                packagePath = (String)packagePath + "monster.creaking.";
                hasEntityStr = false;
                break;
            }
            case FROG: 
            case TADPOLE: {
                str = TARDISStringUtils.uppercaseFirst(disguise.entityType().toString());
                packagePath = (String)packagePath + "animal.frog.";
                hasEntityStr = false;
                break;
            }
            case WARDEN: {
                str = "Warden";
                packagePath = (String)packagePath + "monster.warden.";
                hasEntityStr = false;
                break;
            }
            case BAT: {
                str = "Bat";
                packagePath = (String)packagePath + "ambient.";
                break;
            }
            case CAMEL: {
                str = "Camel";
                packagePath = (String)packagePath + "animal.camel.";
                hasEntityStr = false;
                break;
            }
            case GOAT: {
                str = "Goat";
                packagePath = (String)packagePath + "animal.goat.";
                hasEntityStr = false;
                break;
            }
            case ZOMBIE_HORSE: 
            case SKELETON_HORSE: 
            case TRADER_LLAMA: {
                str = TARDISDisguise.switchAndCapitalise(disguise.entityType().toString());
                packagePath = (String)packagePath + "animal.horse.";
                break;
            }
            case ELDER_GUARDIAN: 
            case WITHER_SKELETON: {
                str = TARDISDisguise.switchAndCapitalise(disguise.entityType().toString());
                packagePath = (String)packagePath + "monster.";
                break;
            }
            case WANDERING_TRADER: {
                str = "VillagerTrader";
                packagePath = (String)packagePath + "npc.";
                break;
            }
            case HUSK: {
                str = "ZombieHusk";
                packagePath = (String)packagePath + "monster.";
                break;
            }
            case STRAY: {
                str = "SkeletonStray";
                packagePath = (String)packagePath + "monster.";
                break;
            }
            case PUFFERFISH: {
                str = "PufferFish";
                packagePath = (String)packagePath + "animal.";
                break;
            }
            case ILLUSIONER: {
                str = "IllagerIllusioner";
                packagePath = (String)packagePath + "monster.";
                break;
            }
            case GIANT: {
                str = "GiantZombie";
                packagePath = (String)packagePath + "monster.";
                break;
            }
            case HORSE: 
            case LLAMA: {
                str = TARDISStringUtils.capitalise(disguise.entityType().toString());
                packagePath = (String)packagePath + "animal.horse.";
                break;
            }
            case DONKEY: 
            case MULE: {
                str = "Horse" + TARDISStringUtils.capitalise(disguise.entityType().toString());
                packagePath = (String)packagePath + "animal.horse.";
                break;
            }
            case VILLAGER: {
                str = "Villager";
                packagePath = (String)packagePath + "npc.";
                break;
            }
            case ZOMBIFIED_PIGLIN: {
                str = "PigZombie";
                packagePath = (String)packagePath + "monster.";
                break;
            }
            case BLAZE: 
            case CREEPER: 
            case DROWNED: 
            case ENDERMAN: 
            case ENDERMITE: 
            case EVOKER: 
            case GHAST: 
            case GUARDIAN: 
            case MAGMA_CUBE: 
            case PHANTOM: 
            case PILLAGER: 
            case RAVAGER: 
            case SHULKER: 
            case SILVERFISH: 
            case SKELETON: 
            case SLIME: 
            case SPIDER: 
            case STRIDER: 
            case VEX: 
            case VINDICATOR: 
            case WITCH: 
            case ZOGLIN: 
            case ZOMBIE: {
                str = TARDISStringUtils.capitalise(disguise.entityType().toString());
                packagePath = (String)packagePath + "monster.";
                break;
            }
            case CAVE_SPIDER: 
            case ZOMBIE_VILLAGER: {
                str = TARDISStringUtils.capitalise(disguise.entityType().toString()).replace(" ", "");
                packagePath = (String)packagePath + "monster.";
                break;
            }
            case HOGLIN: {
                str = "Hoglin";
                packagePath = (String)packagePath + "monster.hoglin.";
                break;
            }
            case ENDER_DRAGON: {
                str = "EnderDragon";
                packagePath = (String)packagePath + "boss.enderdragon.";
                break;
            }
            case WITHER: {
                str = "Wither";
                packagePath = (String)packagePath + "boss.wither.";
                break;
            }
            case PIGLIN: 
            case PIGLIN_BRUTE: {
                str = TARDISStringUtils.capitalise(disguise.entityType().toString());
                packagePath = (String)packagePath + "monster.piglin.";
                break;
            }
            case GLOW_SQUID: {
                str = "GlowSquid";
                hasEntityStr = false;
                break;
            }
            case SNIFFER: {
                str = "Sniffer";
                packagePath = (String)packagePath + "animal.sniffer.";
                hasEntityStr = false;
                break;
            }
            default: {
                str = TARDISStringUtils.capitalise(disguise.entityType().toString());
                packagePath = (String)packagePath + "animal.";
            }
        }
        try {
            String entityPackage = (String)packagePath + (hasEntityStr ? "Entity" : "") + (String)str;
            Class<?> entityClass = Class.forName(entityPackage);
            Constructor<?> constructor = entityClass.getConstructor(EntityType.class, Level.class);
            EntityType type = (EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(CraftNamespacedKey.toMinecraft((NamespacedKey)disguise.entityType().getKey())).get()).value();
            ServerLevel world = ((CraftWorld)w).getHandle();
            Entity entity = (Entity)constructor.newInstance(type, world);
            if (disguise.options() != null) {
                for (Object o : disguise.options()) {
                    Llama llama;
                    Chicken.Variant cv;
                    MushroomCow cow;
                    Parrot.Variant pv;
                    if (o instanceof org.bukkit.DyeColor && disguise.entityType() == org.bukkit.entity.EntityType.SHEEP) {
                        Sheep sheep = (Sheep)entity;
                        sheep.setColor(DyeColor.valueOf((String)o.toString()));
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.AXOLOTL) && o instanceof Axolotl.Variant) {
                        Axolotl.Variant av = (Axolotl.Variant)o;
                        Axolotl axolotl = (Axolotl)entity;
                        Axolotl.Variant variant = Axolotl.Variant.values()[av.ordinal()];
                        axolotl.setVariant(variant);
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.FROG) && o instanceof Frog.Variant) {
                        Frog.Variant fv = (Frog.Variant)o;
                        Frog frog = (Frog)entity;
                        frog.setVariant(CraftFrog.CraftVariant.bukkitToMinecraftHolder((Frog.Variant)fv));
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.RABBIT) && o instanceof Rabbit.Type) {
                        Rabbit.Type rt = (Rabbit.Type)o;
                        Rabbit rabbit = (Rabbit)entity;
                        rabbit.setVariant(Rabbit.Variant.byId((int)rt.ordinal()));
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.PANDA) && o instanceof GENE) {
                        GENE g = (GENE)((Object)o);
                        Panda panda = (Panda)entity;
                        Panda.Gene gene = g.getNmsGene();
                        panda.setMainGene(gene);
                        panda.setHiddenGene(gene);
                    }
                    if (o instanceof Villager.Profession) {
                        Villager.Profession profession = (Villager.Profession)o;
                        if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.VILLAGER)) {
                            Villager villager = (Villager)entity;
                            villager.setVillagerData(villager.getVillagerData().withProfession(CraftVillager.CraftProfession.bukkitToMinecraftHolder((Villager.Profession)profession)));
                        } else if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.ZOMBIE_VILLAGER)) {
                            ZombieVillager zombie = (ZombieVillager)entity;
                            zombie.setVillagerData(zombie.getVillagerData().withProfession(CraftVillager.CraftProfession.bukkitToMinecraftHolder((Villager.Profession)profession)));
                        }
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.PARROT) && o instanceof Parrot.Variant) {
                        pv = (Parrot.Variant)o;
                        Parrot parrot = (Parrot)entity;
                        parrot.setVariant(Parrot.Variant.byId((int)pv.ordinal()));
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.MOOSHROOM) && o instanceof MUSHROOM_COW) {
                        MUSHROOM_COW mc = (MUSHROOM_COW)((Object)o);
                        cow = (MushroomCow)entity;
                        cow.setVariant(mc.getNmsType());
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.WOLF) && o instanceof Wolf.Variant) {
                        Wolf.Variant wv = (Wolf.Variant)o;
                        Wolf wolf = (Wolf)entity;
                        wolf.setVariant(CraftWolf.CraftVariant.bukkitToMinecraftHolder((Wolf.Variant)wv));
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.CHICKEN) && o instanceof Chicken.Variant) {
                        cv = (Chicken.Variant)o;
                        Chicken chicken = (Chicken)entity;
                        chicken.setVariant(CraftChicken.CraftVariant.bukkitToMinecraftHolder((Chicken.Variant)cv));
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.COW) && o instanceof Cow.Variant) {
                        cv = (Cow.Variant)o;
                        cow = (Cow)entity;
                        cow.setVariant(CraftCow.CraftVariant.bukkitToMinecraftHolder((Cow.Variant)cv));
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.PIG) && o instanceof Pig.Variant) {
                        pv = (Pig.Variant)o;
                        Pig pig = (Pig)entity;
                        pig.setVariant(CraftPig.CraftVariant.bukkitToMinecraftHolder((Pig.Variant)pv));
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.CAT) && o instanceof Cat.Type) {
                        Cat.Type c = (Cat.Type)o;
                        Cat cat = (Cat)entity;
                        cat.setVariant(CraftCat.CraftType.bukkitToMinecraftHolder((Cat.Type)c));
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.FOX) && o instanceof FOX) {
                        FOX f = (FOX)((Object)o);
                        Fox fox = (Fox)entity;
                        fox.setVariant(f.getNmsType());
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.HORSE) && o instanceof Horse.Color) {
                        Horse.Color hc = (Horse.Color)o;
                        Horse horse = (Horse)entity;
                        horse.setVariantAndMarkings(Variant.values()[hc.ordinal()], Markings.values()[TARDISConstants.RANDOM.nextInt(Markings.values().length)]);
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.LLAMA) && o instanceof Llama.Color) {
                        Llama.Color lc = (Llama.Color)o;
                        llama = (Llama)entity;
                        llama.setVariant(Llama.Variant.byId((int)lc.ordinal()));
                    }
                    if (o instanceof Boolean) {
                        Boolean bool = (Boolean)o;
                        switch (disguise.entityType()) {
                            case FOX: 
                            case WOLF: 
                            case CAT: {
                                TamableAnimal tameable = (TamableAnimal)entity;
                                tameable.setTame(bool.booleanValue(), false);
                                break;
                            }
                            case DONKEY: 
                            case MULE: {
                                AbstractChestedHorse chesty = (AbstractChestedHorse)entity;
                                chesty.setChest(bool.booleanValue());
                                break;
                            }
                            case SHEEP: {
                                if (!bool.booleanValue()) break;
                                entity.setCustomName((Component)Component.literal((String)"jeb_"));
                                entity.setCustomNameVisible(true);
                                break;
                            }
                            case ENDERMAN: {
                                if (!bool.booleanValue()) break;
                                EnderMan enderman = (EnderMan)entity;
                                BlockState block = Blocks.PURPUR_BLOCK.defaultBlockState();
                                enderman.setCarriedBlock(block);
                                break;
                            }
                            case CREEPER: {
                                Creeper creeper = (Creeper)entity;
                                creeper.setPowered(bool.booleanValue());
                                break;
                            }
                            case BAT: {
                                Bat bat = (Bat)entity;
                                bat.setResting(bool.booleanValue());
                                break;
                            }
                            case SNOW_GOLEM: {
                                SnowGolem snowman = (SnowGolem)entity;
                                snowman.setPumpkin(bool == false);
                                break;
                            }
                            case PILLAGER: {
                                if (!bool.booleanValue()) break;
                                Pillager pillager = (Pillager)entity;
                                net.minecraft.world.item.ItemStack crossbow = CraftItemStack.asNMSCopy((ItemStack)new ItemStack(Material.CROSSBOW));
                                pillager.setItemSlot(EquipmentSlot.MAINHAND, crossbow);
                                pillager.performRangedAttack((LivingEntity)pillager, 1.0f);
                                break;
                            }
                            case LLAMA: {
                                llama = (Llama)entity;
                                ItemStack bukkitItemStack = new ItemStack(CARPET.values()[ThreadLocalRandom.current().nextInt(16)].getCarpet());
                                net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)bukkitItemStack);
                                llama.inventory.setItem(1, nmsItemStack);
                                break;
                            }
                        }
                    }
                    if (o instanceof Integer) {
                        Integer i = (Integer)o;
                        switch (disguise.entityType()) {
                            case MAGMA_CUBE: {
                                MagmaCube magma = (MagmaCube)entity;
                                magma.setSize(i.intValue(), false);
                                break;
                            }
                            case SLIME: {
                                Slime slime = (Slime)entity;
                                slime.setSize(i.intValue(), false);
                                break;
                            }
                            case PUFFERFISH: {
                                Pufferfish puffer = (Pufferfish)entity;
                                puffer.setPuffState(i.intValue());
                                break;
                            }
                        }
                    }
                    if (disguise.entityType().equals((Object)org.bukkit.entity.EntityType.TROPICAL_FISH) && o instanceof TropicalFish.Pattern) {
                        TropicalFish.Pattern pattern = (TropicalFish.Pattern)o;
                        TropicalFish fish = (TropicalFish)entity;
                        int patternType = pattern.ordinal();
                        int baseColour = ThreadLocalRandom.current().nextInt(15);
                        int patternColour = ThreadLocalRandom.current().nextInt(15);
                        TropicalFish.Pattern fishPattern = TropicalFish.Pattern.byId((int)patternType);
                        fish.setPackedVariant(fishPattern.getPackedId());
                        fish.setPackedVariant(TARDISDisguise.packVariant(fishPattern, DyeColor.byId((int)baseColour), DyeColor.byId((int)patternColour)));
                    }
                    if (!(o instanceof AGE)) continue;
                    AGE age = (AGE)((Object)o);
                    if (!AgeableMob.class.isAssignableFrom(entityClass)) continue;
                    AgeableMob ageable = (AgeableMob)entity;
                    ageable.setAge(age.getAge());
                }
            }
            return entity;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.HELPER_SEVERE, "~TARDISDisguise~ " + e.getMessage());
            return null;
        }
    }

    static int packVariant(TropicalFish.Pattern var0, DyeColor var1, DyeColor var2) {
        return var0.getPackedId() & 0xFFFF | (var1.getId() & 0xFF) << 16 | (var2.getId() & 0xFF) << 24;
    }

    private static String switchAndCapitalise(String s) {
        String[] split = s.split("_");
        return TARDISStringUtils.uppercaseFirst(split[1]) + TARDISStringUtils.uppercaseFirst(split[0]);
    }
}

