/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBind;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTransmat;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.Bind;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class TARDISBindListener
implements Listener {
    private final TARDIS plugin;
    private final List<Material> validBlocks = new ArrayList<Material>();

    public TARDISBindListener(TARDIS plugin) {
        this.plugin = plugin;
        this.validBlocks.addAll(Tag.SIGNS.getValues());
        this.validBlocks.addAll(Tag.BUTTONS.getValues());
        this.validBlocks.add(Material.LEVER);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInteract(PlayerInteractEvent event) {
        Material m;
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Block b = event.getClickedBlock();
        if (b != null && this.validBlocks.contains(m = b.getType())) {
            Player player = event.getPlayer();
            UUID uuid = player.getUniqueId();
            String l = b.getLocation().toString();
            HashMap<String, Object> where = new HashMap<String, Object>();
            if (this.plugin.getTrackerKeeper().getBinder().containsKey(uuid)) {
                where.put("bind_id", this.plugin.getTrackerKeeper().getBinder().get(uuid));
                this.plugin.getTrackerKeeper().getBinder().remove(uuid);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("location", l);
                this.plugin.getQueryFactory().doUpdate("bind", set, where);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIND_SAVE", m.toString());
            } else if (this.plugin.getTrackerKeeper().getBindRemoval().containsKey(uuid)) {
                Bind bind = this.plugin.getTrackerKeeper().getBindRemoval().get(uuid);
                HashMap<String, Object> whereb = new HashMap<String, Object>();
                whereb.put("type", bind.getType());
                whereb.put("location", l);
                ResultSetBind rsb = new ResultSetBind(this.plugin, whereb);
                if (rsb.resultSet()) {
                    where.put("bind_id", rsb.getBind_id());
                    this.plugin.getQueryFactory().doDelete("bind", where);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIND_REMOVED", bind.toString());
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIND_REMOVE_NO_MATCH");
                }
                this.plugin.getTrackerKeeper().getBindRemoval().remove(uuid);
            } else {
                where.put("uuid", player.getUniqueId().toString());
                ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, false);
                if (rst.resultSet()) {
                    int id = rst.getTardis_id();
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("tardis_id", id);
                    ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
                    if (rs.resultSet()) {
                        Tardis tardis = rs.getTardis();
                        UUID ownerUUID = tardis.getUuid();
                        HashMap<String, Object> whereb = new HashMap<String, Object>();
                        whereb.put("tardis_id", id);
                        whereb.put("location", l);
                        ResultSetBind rsb = new ResultSetBind(this.plugin, whereb);
                        if (rsb.resultSet()) {
                            if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                                return;
                            }
                            if (tardis.isIsomorphicOn() && !player.getUniqueId().equals(ownerUUID) && !event.useInteractedBlock().equals((Object)Event.Result.DENY) || this.plugin.getTrackerKeeper().getJohnSmith().containsKey(player.getUniqueId())) {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ISO_HANDS_OFF");
                                return;
                            }
                            int type = rsb.getType();
                            if (type != 6 && !tardis.isHandbrakeOn() && !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_TRAVELLING");
                                return;
                            }
                            if (type != 6 && this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_DISPERSED");
                                return;
                            }
                            String name = rsb.getName();
                            switch (type) {
                                case 1: {
                                    if (name.equals("rebuild")) {
                                        player.performCommand("tardis rebuild");
                                        this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, player.getName() + " issued server command: /tardis rebuild");
                                    }
                                    if (name.equals("hide")) {
                                        player.performCommand("tardis hide");
                                        this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, player.getName() + " issued server command: /tardis hide");
                                    }
                                    if (name.equals("home")) {
                                        player.performCommand("tardistravel home");
                                        this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, player.getName() + " issued server command: /tardistravel home");
                                    }
                                    if (name.equals("cave")) {
                                        player.performCommand("tardistravel cave");
                                        this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, player.getName() + " issued server command: /tardistravel cave");
                                    }
                                    if (name.equals("make_her_blue")) {
                                        player.performCommand("tardis make_her_blue");
                                        this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, player.getName() + " issued server command: /tardis make_her_blue");
                                    }
                                    if (!name.equals("occupy")) break;
                                    player.performCommand("tardis occupy");
                                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, player.getName() + " issued server command: /tardis occupy");
                                    break;
                                }
                                case 2: {
                                    player.performCommand("tardistravel " + name);
                                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, player.getName() + " issued server command: /tardistravel " + name);
                                    break;
                                }
                                case 3: {
                                    player.performCommand("tardistravel area " + name);
                                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, player.getName() + " issued server command: /tardistravel area " + name);
                                    break;
                                }
                                case 4: {
                                    player.performCommand("tardistravel biome " + name);
                                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, player.getName() + " issued server command: /tardistravel biome " + name);
                                    break;
                                }
                                case 5: {
                                    HashMap<String, Object> wherec = new HashMap<String, Object>();
                                    HashMap<String, Object> set = new HashMap<String, Object>();
                                    switch (name) {
                                        case "OFF": {
                                            set.put("adapti_on", 0);
                                            set.put("chameleon_preset", "POLICE_BOX_BLUE");
                                            break;
                                        }
                                        case "ADAPT": {
                                            set.put("adapti_on", 1);
                                            set.put("chameleon_preset", "FACTORY");
                                            break;
                                        }
                                        default: {
                                            set.put("adapti_on", 0);
                                            set.put("chameleon_preset", name);
                                        }
                                    }
                                    wherec.put("tardis_id", id);
                                    this.plugin.getQueryFactory().doUpdate("tardis", set, wherec);
                                    player.performCommand("tardis rebuild");
                                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, player.getName() + " issued server command: /tardis rebuild" + name);
                                    break;
                                }
                                case 6: {
                                    if (rsb.getName().equals("console")) {
                                        this.plugin.getGeneralKeeper().getRendererListener().transmat(player);
                                        break;
                                    }
                                    ResultSetTransmat rsm = new ResultSetTransmat(this.plugin, id, rsb.getName());
                                    if (!rsm.resultSet()) break;
                                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT");
                                    Location tp_loc = rsm.getLocation();
                                    tp_loc.setYaw(rsm.getYaw());
                                    tp_loc.setPitch(player.getLocation().getPitch());
                                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                                        player.playSound(tp_loc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                                        player.teleport(tp_loc);
                                    }, 10L);
                                    break;
                                }
                                default: {
                                    player.performCommand("tardistravel dest " + name);
                                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, player.getName() + " issued server command: /tardistravel dest " + name);
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

