/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.QueryFactory;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravelledTo;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public class TARDISWorldChangeListener
implements Listener {
    private final TARDIS plugin;

    public TARDISWorldChangeListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerChangedWorldEvent(PlayerChangedWorldEvent event) {
        this.handleWorld(event.getPlayer());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerJoinEvent(PlayerJoinEvent event) {
        this.handleWorld(event.getPlayer());
    }

    private void handleWorld(Player player) {
        World.Environment environment = player.getWorld().getEnvironment();
        ResultSetTravelledTo rs = new ResultSetTravelledTo(this.plugin);
        if (!rs.resultSet(player.getUniqueId().toString(), environment.toString())) {
            QueryFactory queryFactory = this.plugin.getQueryFactory();
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("uuid", player.getUniqueId().toString());
            values.put("environment", environment.toString());
            queryFactory.doInsert("traveled_to", values);
        }
    }
}

