/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.messaging;

import java.util.Map;
import java.util.TreeMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.RecipeCategory;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class TARDISGiveLister {
    private final TARDIS plugin;
    private final CommandSender sender;
    private final TreeMap<String, String> dev = new TreeMap();

    public TARDISGiveLister(TARDIS plugin, CommandSender sender) {
        this.plugin = plugin;
        this.sender = sender;
        this.dev.put("artron", "Artron Energy");
        this.dev.put("blueprint", "TARDIS Blueprint Disk");
        this.dev.put("kit", "TARDIS Item Kit");
        this.dev.put("recipes", "Grant TARDIS recipes");
        this.dev.put("seed", "TARDIS Seed Block");
    }

    public void list() {
        this.plugin.getMessenger().message(this.sender, TardisModule.TARDIS, "You can 'give' the following items:");
        this.plugin.getMessenger().messageWithColour(this.sender, "Hover over command argument to see a description", "#AAAAAA");
        this.plugin.getMessenger().messageWithColour(this.sender, "Click to suggest a command", "#AAAAAA");
        this.plugin.getMessenger().message(this.sender, "");
        this.plugin.getMessenger().message(this.sender, "Admin & development");
        for (Map.Entry<String, String> entry : this.dev.entrySet()) {
            this.plugin.getMessenger().sendSuggestCommand(this.sender, entry.getKey(), entry.getValue(), "#FFFF55");
        }
        this.plugin.getMessenger().message(this.sender, "");
        for (RecipeCategory category : RecipeCategory.values()) {
            if (category == RecipeCategory.UNUSED || category == RecipeCategory.UNCRAFTABLE || category == RecipeCategory.CUSTOM_BLOCKS || category == RecipeCategory.ROTORS || category == RecipeCategory.MISC) continue;
            this.plugin.getMessenger().message(this.sender, category.getName());
            for (RecipeItem item : RecipeItem.values()) {
                if (item.getCategory() != category) continue;
                this.plugin.getMessenger().sendSuggestCommand(this.sender, item.toTabCompletionString(), item.toRecipeString(), category.getColour());
            }
            this.plugin.getMessenger().message(this.sender, "");
        }
        this.plugin.getMessenger().sendShowMore(this.sender, "tardisgive");
    }

    public void listMore() {
        this.plugin.getMessenger().message(this.sender, "");
        for (RecipeCategory category : RecipeCategory.values()) {
            if (category != RecipeCategory.CUSTOM_BLOCKS && category != RecipeCategory.ROTORS && category != RecipeCategory.MISC) continue;
            this.plugin.getMessenger().message(this.sender, category.getName());
            for (RecipeItem item : RecipeItem.values()) {
                if (item.getCategory() != category) continue;
                this.plugin.getMessenger().sendSuggestCommand(this.sender, item.toTabCompletionString(), item.toRecipeString(), category.getColour());
            }
            this.plugin.getMessenger().message(this.sender, "");
        }
    }
}

