/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.planets;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.move.TARDISMoveSession;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class TARDISAcidWater
implements Listener {
    private final TARDIS plugin;
    private final List<Player> burningPlayers = new ArrayList<Player>();

    public TARDISAcidWater(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (this.burningPlayers.contains(event.getEntity())) {
            String name = event.getEntity().getName();
            event.deathMessage((Component)Component.text((String)(name + " was dissolved in acid")));
        }
        this.burningPlayers.remove(event.getEntity());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent e) {
        final Player player = e.getPlayer();
        final Location loc = player.getLocation();
        TARDISMoveSession tms = this.plugin.getTrackerKeeper().getTARDISMoveSession(player);
        if (tms.isStaleLocation()) {
            return;
        }
        if (player.isDead()) {
            return;
        }
        if (!player.getWorld().getName().equalsIgnoreCase("skaro")) {
            return;
        }
        if (TARDISPermission.hasPermission(player, "tardis.acid.bypass")) {
            return;
        }
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        Block block = loc.getBlock();
        Block head = block.getRelative(BlockFace.UP);
        if (!block.isLiquid() && !head.isLiquid()) {
            return;
        }
        if (this.burningPlayers.contains(player)) {
            return;
        }
        if (block.getType().equals((Object)Material.WATER) || head.getType().equals((Object)Material.WATER)) {
            Entity playersVehicle = player.getVehicle();
            if (playersVehicle != null && this.isBoat(playersVehicle.getType())) {
                return;
            }
            Collection activePotions = player.getActivePotionEffects();
            for (PotionEffect s : activePotions) {
                if (!s.getType().equals(PotionEffectType.WATER_BREATHING)) continue;
                return;
            }
            this.burningPlayers.add(player);
            new BukkitRunnable(){

                public void run() {
                    if (player.isDead()) {
                        TARDISAcidWater.this.burningPlayers.remove(player);
                        this.cancel();
                    } else if ((player.getLocation().getBlock().isLiquid() || player.getLocation().getBlock().getRelative(BlockFace.UP).isLiquid()) && player.getLocation().getWorld().getName().equalsIgnoreCase("skaro")) {
                        double ad;
                        if (!TARDISAcidWater.this.plugin.getPlanetsConfig().getStringList("planets.skaro.acid_potions").isEmpty()) {
                            TARDISAcidWater.this.plugin.getPlanetsConfig().getStringList("planets.skaro.acid_potions").forEach(t -> {
                                PotionEffectType pet = (PotionEffectType)RegistryAccess.registryAccess().getRegistry(RegistryKey.MOB_EFFECT).get(new NamespacedKey("minecraft", t.toLowerCase(Locale.ROOT)));
                                if (pet != null) {
                                    if (pet.equals(PotionEffectType.BLINDNESS) || pet.equals(PotionEffectType.NAUSEA) || pet.equals(PotionEffectType.HUNGER) || pet.equals(PotionEffectType.SLOWNESS) || pet.equals(PotionEffectType.MINING_FATIGUE) || pet.equals(PotionEffectType.WEAKNESS)) {
                                        player.addPotionEffect(new PotionEffect(pet, 200, 1));
                                    } else {
                                        player.addPotionEffect(new PotionEffect(pet, 50, 1));
                                    }
                                }
                            });
                        }
                        if ((ad = TARDISAcidWater.this.plugin.getPlanetsConfig().getDouble("planets.skaro.acid_damage")) > 0.0) {
                            double damage = (ad - ad * TARDISAcidWater.this.getDamageReduced(player)) / 2.5;
                            player.damage(damage, DamageSource.builder((DamageType)DamageType.GENERIC).build());
                            player.getWorld().playSound(loc, Sound.ENTITY_CREEPER_PRIMED, 3.0f, 3.0f);
                        }
                    } else {
                        TARDISAcidWater.this.burningPlayers.remove(player);
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        }
    }

    private double getDamageReduced(Player player) {
        PlayerInventory inv = player.getInventory();
        ItemStack boots = inv.getBoots();
        ItemStack helmet = inv.getHelmet();
        ItemStack chest = inv.getChestplate();
        ItemStack pants = inv.getLeggings();
        double reduction = 0.0;
        if (helmet != null) {
            switch (helmet.getType()) {
                case TURTLE_HELMET: {
                    reduction += 0.02;
                    break;
                }
                case LEATHER_HELMET: {
                    reduction += 0.04;
                    break;
                }
                case GOLDEN_HELMET: {
                    reduction += 0.06;
                    break;
                }
                case CHAINMAIL_HELMET: {
                    reduction += 0.08;
                    break;
                }
                case IRON_HELMET: {
                    reduction += 0.1;
                    break;
                }
                case DIAMOND_HELMET: {
                    reduction += 0.12;
                    break;
                }
                case NETHERITE_HELMET: {
                    reduction += 0.14;
                    break;
                }
            }
        }
        if (boots != null) {
            switch (boots.getType()) {
                case LEATHER_BOOTS: {
                    reduction += 0.04;
                    break;
                }
                case GOLDEN_BOOTS: {
                    reduction += 0.06;
                    break;
                }
                case CHAINMAIL_BOOTS: {
                    reduction += 0.08;
                    break;
                }
                case IRON_BOOTS: {
                    reduction += 0.1;
                    break;
                }
                case DIAMOND_BOOTS: {
                    reduction += 0.12;
                    break;
                }
                case NETHERITE_BOOTS: {
                    reduction += 0.14;
                    break;
                }
            }
        }
        if (pants != null) {
            switch (pants.getType()) {
                case LEATHER_LEGGINGS: {
                    reduction += 0.08;
                    break;
                }
                case GOLDEN_LEGGINGS: {
                    reduction += 0.12;
                    break;
                }
                case CHAINMAIL_LEGGINGS: {
                    reduction += 0.16;
                    break;
                }
                case IRON_LEGGINGS: {
                    reduction += 0.2;
                    break;
                }
                case DIAMOND_LEGGINGS: {
                    reduction += 0.24;
                    break;
                }
                case NETHERITE_LEGGINGS: {
                    reduction += 0.28;
                    break;
                }
            }
        }
        if (chest != null) {
            switch (chest.getType()) {
                case LEATHER_CHESTPLATE: {
                    reduction += 0.12;
                    break;
                }
                case GOLDEN_CHESTPLATE: {
                    reduction += 0.16;
                    break;
                }
                case CHAINMAIL_CHESTPLATE: {
                    reduction += 0.2;
                    break;
                }
                case IRON_CHESTPLATE: {
                    reduction += 0.24;
                    break;
                }
                case DIAMOND_CHESTPLATE: {
                    reduction += 0.28;
                    break;
                }
                case NETHERITE_CHESTPLATE: {
                    reduction += 0.32;
                    break;
                }
            }
        }
        return reduction;
    }

    @EventHandler
    public void onFillAcidBucket(PlayerBucketFillEvent event) {
        Player p = event.getPlayer();
        if (!p.getWorld().getName().equalsIgnoreCase("skaro")) {
            return;
        }
        Material type = event.getBlockClicked().getType();
        ItemStack bucket = event.getItemStack();
        ItemMeta im = bucket.getItemMeta();
        if (type.equals((Object)Material.WATER)) {
            im.displayName((Component)Component.text((String)"Acid Bucket"));
        }
        if (type.equals((Object)Material.LAVA)) {
            im.displayName((Component)Component.text((String)"Rust Bucket"));
        }
        bucket.setItemMeta(im);
        p.updateInventory();
    }

    private boolean isBoat(EntityType type) {
        switch (type) {
            case ACACIA_BOAT: 
            case BIRCH_BOAT: 
            case CHERRY_BOAT: 
            case DARK_OAK_BOAT: 
            case JUNGLE_BOAT: 
            case MANGROVE_BOAT: 
            case OAK_BOAT: 
            case PALE_OAK_BOAT: 
            case SPRUCE_BOAT: {
                return true;
            }
        }
        return false;
    }
}

