/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.planets;

import me.eccentric_nz.TARDIS.TARDIS;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;

public class TARDISResourcePackSwitcher
implements Listener {
    private final TARDIS plugin;

    public TARDISResourcePackSwitcher(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResourcePackWorldChange(PlayerChangedWorldEvent event) {
        String path;
        Player player = event.getPlayer();
        String world = player.getWorld().getName();
        String from = this.plugin.getPlanetsConfig().getString("planets." + event.getFrom().getName() + ".resource_pack");
        if (from == null) {
            from = "default";
        }
        if ((path = this.plugin.getPlanetsConfig().getString("planets." + world + ".resource_pack")) == null) {
            path = "default";
        }
        if (!from.equals(path)) {
            this.setResourcePack(player, path);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (this.plugin.getPlanetsConfig().getBoolean("set_pack_on_join")) {
            Player player = event.getPlayer();
            String world = player.getWorld().getName();
            String path = this.plugin.getPlanetsConfig().getString("planets." + world + ".resource_pack");
            this.setResourcePack(player, path);
        }
    }

    private void setResourcePack(Player player, String path) {
        if (path == null || path.equalsIgnoreCase("default")) {
            player.removeResourcePacks();
        }
        if (player.isOnline()) {
            player.setResourcePack(path);
        }
    }
}

