/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.portal;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.portal.CastData;
import me.eccentric_nz.TARDIS.portal.MatrixUtils;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Cast {
    private final TARDIS plugin;
    private final Location location;

    public Cast(TARDIS plugin, Location location) {
        this.plugin = plugin;
        this.location = location;
    }

    public void castInterior(UUID uuid, BlockData[][][] capture) {
        int zz;
        int yy;
        int xx;
        int z;
        int x;
        int y;
        int sz;
        int sx;
        int bz;
        int bx;
        Player player = this.plugin.getServer().getPlayer(uuid);
        if (player == null) {
            return;
        }
        CastData castData = this.plugin.getTrackerKeeper().getCasters().get(uuid);
        if (castData == null) {
            return;
        }
        int layers = capture.length;
        COMPASS facing = castData.direction();
        int sizeX = facing == COMPASS.NORTH || facing == COMPASS.SOUTH ? capture[0].length : capture[0][0].length;
        int sizeZ = facing == COMPASS.NORTH || facing == COMPASS.SOUTH ? capture[0][0].length : capture[0].length;
        int sizeR = Math.max(sizeX, sizeZ);
        World world = this.location.getWorld();
        BlockData[][][] rotated = switch (facing) {
            case COMPASS.NORTH -> {
                bx = -sizeX / 2;
                bz = -sizeZ;
                sx = -sizeR / 2;
                sz = -sizeR;
                yield MatrixUtils.rotateToNorth(capture);
            }
            case COMPASS.WEST -> {
                bx = -sizeX;
                bz = -sizeZ / 2;
                sx = -sizeR;
                sz = -sizeR / 2;
                yield MatrixUtils.rotateToWest(capture);
            }
            case COMPASS.EAST -> {
                bx = 1;
                bz = -sizeZ / 2;
                sx = 1;
                sz = -sizeR / 2;
                yield MatrixUtils.rotateToEast(capture);
            }
            default -> {
                bx = -sizeX / 2;
                bz = 1;
                sx = -sizeR / 2;
                sz = 1;
                yield capture;
            }
        };
        int startX = this.location.getBlockX() + bx;
        int startY = this.location.getBlockY() - 1;
        int startZ = this.location.getBlockZ() + bz;
        int restoreX = this.location.getBlockX() + sx;
        int restoreY = this.location.getBlockY() - 1;
        int restoreZ = this.location.getBlockZ() + sz;
        HashSet<Block> restore = new HashSet<Block>();
        for (y = 0; y < 7; ++y) {
            for (x = 0; x < sizeR; ++x) {
                for (z = 0; z < sizeR; ++z) {
                    xx = restoreX + x;
                    yy = restoreY + y;
                    zz = restoreZ + z;
                    restore.add(world.getBlockAt(xx, yy, zz));
                }
            }
        }
        this.plugin.getTrackerKeeper().getCastRestore().put(uuid, restore);
        for (y = 0; y < layers; ++y) {
            for (x = 0; x < sizeX; ++x) {
                for (z = 0; z < sizeZ; ++z) {
                    xx = startX + x;
                    yy = startY + y;
                    zz = startZ + z;
                    if (rotated[y][x][z] == null) continue;
                    player.sendBlockChange(new Location(world, (double)xx, (double)yy, (double)zz), rotated[y][x][z]);
                }
            }
        }
    }

    public void restoreExterior(UUID uuid) {
        Set<Block> restore = this.plugin.getTrackerKeeper().getCastRestore().get(uuid);
        if (restore != null) {
            for (Block b : restore) {
                b.getState().update();
            }
        }
    }

    public void castRotor(ItemFrame rotor, Player player, Vector offset, COMPASS direction) {
        double tx = offset.getX();
        double tz = offset.getZ();
        switch (direction) {
            case EAST: {
                offset.setX(tz);
                offset.setZ(-tx);
                break;
            }
            case WEST: {
                offset.setX(-tz);
                offset.setZ(tx);
                break;
            }
            case NORTH: {
                offset.setX(-tx);
                offset.setZ(-tz);
                break;
            }
        }
        Location frame = this.location.clone().add(offset);
        int rotorId = this.plugin.getTardisHelper().castFakeItemFrame(rotor, player, new Vector(frame.getBlockX(), frame.getBlockY(), frame.getBlockZ()));
        this.plugin.getTrackerKeeper().getRotorRestore().put(player.getUniqueId(), rotorId);
    }
}

