/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.recipes;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.enumeration.CraftingDifficulty;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class TARDISDisplayItemRecipe {
    private final TARDIS plugin;

    public TARDISDisplayItemRecipe(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void addDisplayItemRecipes() {
        for (TARDISDisplayItem tdi : TARDISDisplayItem.values()) {
            if (tdi.getCraftMaterial() == null) continue;
            ItemStack is = tdi == TARDISDisplayItem.CLASSIC_DOOR || tdi == TARDISDisplayItem.BONE_DOOR ? ItemStack.of((Material)tdi.getCraftMaterial(), (int)1) : ItemStack.of((Material)tdi.getMaterial(), (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)ComponentUtils.toWhite(tdi.getDisplayName()));
            if (tdi.getCustomModel() != null) {
                im.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)tdi.getCustomModel().getKey());
                if (tdi.isDoor()) {
                    im.setItemModel(tdi.getCustomModel());
                }
            }
            is.setItemMeta(im);
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, tdi.getName());
            ShapedRecipe r = new ShapedRecipe(key, is);
            r.shape(new String[]{"#A#", "#D#", "###"});
            r.setIngredient('#', this.plugin.getCraftingDifficulty() == CraftingDifficulty.HARD ? Material.GLASS : Material.GLASS_PANE);
            r.setIngredient('A', tdi.getCraftMaterial());
            r.setIngredient('D', tdi.getMaterial());
            this.plugin.getServer().addRecipe((Recipe)r);
            this.plugin.getFigura().getShapedRecipes().put(tdi.getDisplayName(), r);
        }
    }
}

