/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms;

import com.google.gson.JsonObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisTimeLord;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.TARDISRoomData;
import me.eccentric_nz.TARDIS.rooms.TARDISRoomRunnable;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class TARDISRoomPersister {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;
    private int count = 0;

    public TARDISRoomPersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProgress() {
        try {
            this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "room_progress (`direction`, `room`, `location`, `tardis_id`, `progress_row`, `progress_column`, `progress_level`, `middle_type`, `floor_type`, `post_blocks`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            for (TARDISRoomData rd : this.plugin.getTrackerKeeper().getRoomTasks().values()) {
                this.ps.setString(1, rd.getDirection().toString());
                this.ps.setString(2, rd.getRoom());
                Location location = rd.getLocation();
                String l = TARDISStaticLocationGetters.makeLocationStr(location);
                this.ps.setString(3, l);
                this.ps.setInt(4, rd.getTardis_id());
                this.ps.setInt(5, rd.getRow());
                this.ps.setInt(6, rd.getColumn());
                this.ps.setInt(7, rd.getLevel());
                this.ps.setString(8, rd.getMiddleType().toString());
                this.ps.setString(9, rd.getFloorType().toString());
                this.ps.setString(10, String.join((CharSequence)"@", rd.getPostBlocks()));
                this.count += this.ps.executeUpdate();
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.count + " room building tasks to resume later.");
            }
        }
        catch (SQLException e) {
            this.plugin.debug("Error inserting room_progress records: " + e.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing insert room_progress statement: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        PreparedStatement delete = null;
        ResultSet rs = null;
        try {
            delete = this.connection.prepareStatement("DELETE FROM " + this.prefix + "room_progress WHERE progress_id = ?");
            this.ps = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "room_progress");
            rs = this.ps.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    String whichroom = rs.getString("room");
                    JsonObject obj = TARDISSchematicGZip.getObject(this.plugin, "rooms", whichroom.toLowerCase(Locale.ROOT), this.plugin.getRoomsConfig().getBoolean("rooms." + whichroom + ".user"));
                    if (obj == null) continue;
                    TARDISRoomData rd = new TARDISRoomData();
                    rd.setSchematic(obj);
                    rd.setRoom(whichroom);
                    Location location = TARDISStaticLocationGetters.getLocationFromDB(rs.getString("location"));
                    rd.setLocation(location);
                    int id = rs.getInt("tardis_id");
                    rd.setTardis_id(id);
                    rd.setRow(rs.getInt("progress_row"));
                    rd.setColumn(rs.getInt("progress_column"));
                    rd.setLevel(rs.getInt("progress_level"));
                    rd.setDirection(COMPASS.valueOf(rs.getString("direction")));
                    rd.setMiddleType(Material.valueOf((String)rs.getString("middle_type")));
                    rd.setFloorType(Material.valueOf((String)rs.getString("floor_type")));
                    ArrayList<String> postBlocks = new ArrayList<String>(List.of(rs.getString("post_blocks").split("@")));
                    rd.setPostBlocks(postBlocks);
                    long delay = Math.round(20.0 / this.plugin.getConfig().getDouble("growth.room_speed"));
                    ResultSetTardisTimeLord rst = new ResultSetTardisTimeLord(this.plugin);
                    if (!rst.fromID(id)) continue;
                    TARDISRoomRunnable runnable = new TARDISRoomRunnable(this.plugin, rd, rst.getUuid());
                    int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, delay, delay);
                    runnable.setTask(taskID);
                    this.plugin.getTrackerKeeper().getRoomTasks().put(taskID, rd);
                    delete.setInt(1, rs.getInt("progress_id"));
                    delete.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("Error reading resume room_progress data: " + e.getMessage());
        }
        finally {
            try {
                if (delete != null) {
                    delete.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing resume room_progress statement(s): " + ex.getMessage());
            }
        }
    }
}

