/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.ClearEyeControls;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

class TARDISRoomRemover {
    private final TARDIS plugin;
    private final String r;
    private final Location l;
    private final COMPASS d;
    private final int id;

    TARDISRoomRemover(TARDIS plugin, String r, Location l, COMPASS d, int id) {
        this.plugin = plugin;
        this.r = r;
        this.l = l;
        this.d = d;
        this.id = id;
    }

    public boolean remove() {
        int check_distance;
        int n = check_distance = this.r.equals("ARBORETUM") ? 5 : 7;
        if (this.l.getBlock().getRelative(BlockFace.DOWN).getRelative(BlockFace.valueOf((String)this.d.toString()), check_distance).getType().isAir()) {
            return false;
        }
        JsonObject obj = TARDISSchematicGZip.getObject(this.plugin, "rooms", this.r.toLowerCase(Locale.ROOT), this.plugin.getRoomsConfig().getBoolean("rooms." + this.r + ".user"));
        if (obj == null) {
            return false;
        }
        JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
        int h = dimensions.get("height").getAsInt();
        int wid = dimensions.get("width").getAsInt();
        int downy = Math.abs(this.plugin.getRoomsConfig().getInt("rooms." + this.r + ".offset"));
        int upy = h - (downy + 1);
        int xzoffset = wid / 2;
        switch (this.d) {
            case NORTH: {
                this.l.setX(this.l.getX() - (double)xzoffset);
                this.l.setZ(this.l.getZ() - (double)wid);
                break;
            }
            case WEST: {
                this.l.setX(this.l.getX() - (double)wid);
                this.l.setZ(this.l.getZ() - (double)xzoffset);
                break;
            }
            case SOUTH: {
                this.l.setX(this.l.getX() - (double)xzoffset);
                break;
            }
            default: {
                this.l.setZ(this.l.getZ() - (double)xzoffset);
            }
        }
        int sx = this.l.getBlockX();
        int ex = this.l.getBlockX() + (wid - 1);
        int sz = this.l.getBlockZ();
        int ez = this.l.getBlockZ() + (wid - 1);
        int sy = this.l.getBlockY() + upy;
        int ey = this.l.getBlockY() - downy;
        World w = this.l.getWorld();
        for (int y = sy; y >= ey; --y) {
            for (int x = sx; x <= ex; ++x) {
                for (int z = sz; z <= ez; ++z) {
                    Block block = w.getBlockAt(x, y, z);
                    if ((this.r.equals("GRAVITY") || this.r.equals("ANTIGRAVITY")) && (block.getType().equals((Object)Material.LIME_WOOL) || block.getType().equals((Object)Material.PINK_WOOL))) {
                        String loc = new Location(w, (double)x, (double)y, (double)z).toString();
                        HashMap<String, Object> where = new HashMap<String, Object>();
                        where.put("location", loc);
                        where.put("tardis_id", this.id);
                        this.plugin.getQueryFactory().doDelete("gravity_well", where);
                    }
                    if (this.r.equals("EYE")) {
                        if (block.getType() == Material.IRON_DOOR) {
                            block.setBlockData(TARDISConstants.AIR);
                            block.getRelative(BlockFace.DOWN).setBlockData(TARDISConstants.AIR);
                        }
                        w.setBiome(x, y, z, Biome.THE_VOID);
                    }
                    block.setBlockData(TARDISConstants.AIR);
                }
            }
        }
        if (this.r.equals("FARM") || this.r.equals("APIARY") || this.r.equals("HUTCH") || this.r.equals("IGLOO") || this.r.equals("RAIL") || this.r.equals("STABLE") || this.r.equals("STALL") || this.r.equals("VILLAGE") || this.r.equals("BIRDCAGE") || this.r.equals("AQUARIUM") || this.r.equals("BAMBOO")) {
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put(this.r.toLowerCase(Locale.ROOT), "");
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", this.id);
            this.plugin.getQueryFactory().doUpdate("farming", set, where);
        }
        if (this.r.equals("EYE")) {
            new ClearEyeControls(this.plugin).removeRecords(this.id);
        }
        return true;
    }
}

