/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.library;

import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.rooms.library.EnchantmentShelf;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TextDisplay;
import org.bukkit.util.Transformation;

public class LibraryCatalogue {
    public void label(Location start) {
        for (EnchantmentShelf shelf : EnchantmentShelf.values()) {
            Block block = start.clone().add(shelf.getPosition()).getBlock().getRelative(shelf.getFacing());
            Location card = block.getLocation();
            float yaw = switch (shelf.getFacing()) {
                case BlockFace.SOUTH -> {
                    card.add(0.5, 0.5, 0.1);
                    yield 0.0f;
                }
                case BlockFace.EAST -> {
                    card.add(0.1, 0.5, 0.5);
                    yield -90.0f;
                }
                case BlockFace.NORTH -> {
                    card.add(0.5, 0.5, 0.9);
                    yield 180.0f;
                }
                default -> {
                    card.add(0.9, 0.5, 0.5);
                    yield 90.0f;
                }
            };
            for (int l = 1; l <= shelf.getMaxLevel(); ++l) {
                Location text = card.clone().add(0.0, (double)l, 0.0);
                TextDisplay display = (TextDisplay)start.getWorld().spawnEntity(text, EntityType.TEXT_DISPLAY);
                display.text((Component)Component.text((String)(shelf.getMinecraftName() + this.roman(l))));
                display.setAlignment(TextDisplay.TextAlignment.CENTER);
                display.setTransformation(new Transformation(TARDISConstants.VECTOR_ZERO, TARDISConstants.AXIS_ANGLE_ZERO, TARDISConstants.VECTOR_QUARTER, TARDISConstants.AXIS_ANGLE_ZERO));
                display.setBillboard(Display.Billboard.FIXED);
                display.setRotation(yaw, 0.0f);
            }
        }
    }

    private String roman(int i) {
        return switch (i) {
            case 5 -> " V";
            case 4 -> " IV";
            case 3 -> " III";
            case 2 -> " II";
            default -> " I";
        };
    }
}

