/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.siegemode;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetSiege;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.siegemode.TARDISSiegeArea;
import org.bukkit.Chunk;
import org.bukkit.command.CommandSender;

public class TARDISSiegePersister {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private int count = 0;

    public TARDISSiegePersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSiege() {
        try {
            this.ps = this.connection.prepareStatement("SELECT tardis_id, siege_on FROM " + this.prefix + "tardis");
            this.rs = this.ps.executeQuery();
            if (this.rs.isBeforeFirst()) {
                while (this.rs.next()) {
                    if (!this.rs.getBoolean("siege_on")) continue;
                    int id = this.rs.getInt("tardis_id");
                    this.plugin.getTrackerKeeper().getInSiegeMode().add(id);
                    if (this.plugin.getConfig().getInt("siege.breeding") > 0 || this.plugin.getConfig().getInt("siege.growth") > 0) {
                        Chunk c = this.plugin.getLocationUtils().getTARDISChunk(id);
                        TARDISSiegeArea tsa = new TARDISSiegeArea(id, c);
                        if (this.plugin.getConfig().getInt("siege.breeding") > 0) {
                            List<TARDISSiegeArea> breeding_areas = this.plugin.getTrackerKeeper().getSiegeBreedingAreas().get(c.getWorld().getName());
                            if (breeding_areas == null) {
                                breeding_areas = new ArrayList<TARDISSiegeArea>();
                            }
                            breeding_areas.add(tsa);
                            this.plugin.getTrackerKeeper().getSiegeBreedingAreas().put(c.getWorld().getName(), breeding_areas);
                        }
                        if (this.plugin.getConfig().getInt("siege.growth") > 0) {
                            List<TARDISSiegeArea> growth_areas = this.plugin.getTrackerKeeper().getSiegeGrowthAreas().get(c.getWorld().getName());
                            if (growth_areas == null) {
                                growth_areas = new ArrayList<TARDISSiegeArea>();
                            }
                            growth_areas.add(tsa);
                            this.plugin.getTrackerKeeper().getSiegeGrowthAreas().put(c.getWorld().getName(), growth_areas);
                        }
                    }
                    ++this.count;
                }
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Loaded " + this.count + " TARDISes in Siege Mode.");
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for tardis table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing tardis statement or resultset: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCubes() {
        ResultSetSiege rss = new ResultSetSiege(this.plugin);
        if (rss.resultSet()) {
            HashMap<UUID, Integer> data = rss.getData();
            this.plugin.getTrackerKeeper().getSiegeCarrying().putAll(data);
            this.plugin.getTrackerKeeper().getIsSiegeCube().addAll(data.values());
            try {
                this.ps = this.connection.prepareStatement("DELETE FROM " + this.prefix + "siege");
                this.ps.executeUpdate();
            }
            catch (SQLException ex) {
                this.plugin.debug("Delete error for siege table: " + ex.getMessage());
            }
            finally {
                try {
                    if (this.ps != null) {
                        this.ps.close();
                    }
                }
                catch (SQLException ex) {
                    this.plugin.debug("Error closing delete siege statement: " + ex.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCubes() {
        try {
            this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "siege (uuid, tardis_id) VALUES (?, ?)");
            int i = 0;
            for (Map.Entry<UUID, Integer> map : this.plugin.getTrackerKeeper().getSiegeCarrying().entrySet()) {
                this.ps.setString(1, map.getKey().toString());
                this.ps.setInt(2, map.getValue());
                i += this.ps.executeUpdate();
            }
            if (i > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + i + " Siege Cubes");
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("Insert error for siege table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing insert siege statement: " + ex.getMessage());
            }
        }
    }
}

