/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.custommodels.keys.SonicItem;
import me.eccentric_nz.TARDIS.database.data.Sonic;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetSonic;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisArtron;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.sonic.TARDISSonicActivatorInventory;
import me.eccentric_nz.TARDIS.sonic.TARDISSonicGeneratorInventory;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.util.Vector;

public class TARDISSonicGeneratorListener
implements Listener {
    private final TARDIS plugin;

    public TARDISSonicGeneratorListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!block.getType().equals((Object)Material.FLOWER_POT)) {
            return;
        }
        String location = block.getLocation().toString();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("type", 24);
        where.put("location", location);
        ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
        if (rsc.resultSet() && event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            Player player = event.getPlayer();
            UUID uuid = player.getUniqueId();
            HashMap<String, Object> wheres = new HashMap<String, Object>();
            wheres.put("uuid", uuid.toString());
            ResultSetSonic rss = new ResultSetSonic(this.plugin, wheres);
            if (rss.resultSet()) {
                Sonic s = rss.getSonic();
                if (s.isActivated()) {
                    if (player.isSneaking()) {
                        this.generate(player, block.getLocation(), s);
                    } else {
                        this.plugin.getTrackerKeeper().getSonicGenerators().put(uuid, block.getLocation());
                        player.openInventory(new TARDISSonicGeneratorInventory(this.plugin, s).getInventory());
                    }
                } else {
                    this.openActivate(player);
                }
            } else {
                this.openActivate(player);
            }
        }
    }

    private void generate(Player p, Location location, Sonic s) {
        ResultSetTardisArtron rs = new ResultSetTardisArtron(this.plugin);
        if (rs.fromUUID(p.getUniqueId().toString())) {
            double full = this.plugin.getArtronConfig().getDouble("full_charge") / 100.0;
            int cost = (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.standard") * full);
            int level = rs.getArtronLevel();
            ItemStack sonic = ItemStack.of((Material)Material.BLAZE_ROD, (int)1);
            ItemMeta screw = sonic.getItemMeta();
            screw.displayName((Component)ComponentUtils.toWhite("Sonic Screwdriver"));
            ArrayList<TextComponent> upgrades = new ArrayList<TextComponent>();
            if (s.hasKnockback()) {
                upgrades.add(Component.text((String)"Knockback Upgrade"));
                cost += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.knockback") * full);
            }
            if (s.hasBio()) {
                upgrades.add(Component.text((String)"Bio-scanner Upgrade"));
                cost += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.bio") * full);
            }
            if (s.hasDiamond()) {
                upgrades.add(Component.text((String)"Diamond Upgrade"));
                cost += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.diamond") * full);
            }
            if (s.hasEmerald()) {
                upgrades.add(Component.text((String)"Emerald Upgrade"));
                cost += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.emerald") * full);
            }
            if (s.hasRedstone()) {
                upgrades.add(Component.text((String)"Redstone Upgrade"));
                cost += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.bio") * full);
            }
            if (s.hasPainter()) {
                upgrades.add(Component.text((String)"Painter Upgrade"));
                cost += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.painter") * full);
            }
            if (s.hasIgnite()) {
                upgrades.add(Component.text((String)"Ignite Upgrade"));
                cost += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.ignite") * full);
            }
            if (s.hasArrow()) {
                upgrades.add(Component.text((String)"Pickup Arrows Upgrade"));
                cost += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.arrow") * full);
            }
            if (s.hasBrush()) {
                upgrades.add(Component.text((String)"Brush Upgrade"));
                cost += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.brush") * full);
            }
            if (s.hasConversion()) {
                upgrades.add(Component.text((String)"Conversion Upgrade"));
                cost += (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.conversion") * full);
            }
            if (!upgrades.isEmpty()) {
                ArrayList<TextComponent> finalUps = new ArrayList<TextComponent>();
                finalUps.add(Component.text((String)"Upgrades:"));
                finalUps.addAll(upgrades);
                screw.lore(finalUps);
            }
            CustomModelDataComponent component = screw.getCustomModelDataComponent();
            component.setFloats(s.getModel());
            screw.setCustomModelDataComponent(component);
            sonic.setItemMeta(screw);
            if (cost < level) {
                Location loc = location.clone().add(0.5, 0.75, 0.5);
                Item drop = location.getWorld().dropItem(loc, sonic);
                drop.setVelocity(new Vector(0, 0, 0));
                this.plugin.getTrackerKeeper().getSonicGenerators().remove(p.getUniqueId());
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", p.getUniqueId().toString());
                this.plugin.getQueryFactory().alterEnergyLevel("tardis", -cost, where, p);
            } else {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "UPGRADE_ABORT_ENERGY");
            }
        }
    }

    private void openActivate(Player p) {
        p.openInventory(new TARDISSonicActivatorInventory(this.plugin).getInventory());
    }

    @EventHandler(ignoreCancelled=true)
    public void onSonicGeneratorBreak(BlockBreakEvent event) {
        Block b = event.getBlock();
        if (!b.getType().equals((Object)Material.FLOWER_POT)) {
            return;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("type", 24);
        where.put("location", b.getLocation().toString());
        ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
        if (!rsc.resultSet()) {
            return;
        }
        HashMap<String, Object> wheres = new HashMap<String, Object>();
        wheres.put("uuid", event.getPlayer().getUniqueId().toString());
        ResultSetSonic rss = new ResultSetSonic(this.plugin, wheres);
        if (rss.resultSet() && rss.getSonic().isActivated()) {
            event.setCancelled(true);
            TARDISDisplayItemUtils.remove(b);
            b.setBlockData(TARDISConstants.AIR);
            ItemStack is = ItemStack.of((Material)Material.FLOWER_POT, (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)Component.text((String)"Sonic Generator"));
            im.setItemModel(SonicItem.SONIC_GENERATOR.getKey());
            is.setItemMeta(im);
            b.getWorld().dropItemNaturally(b.getLocation(), is);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSonicGeneratorPlace(BlockPlaceEvent event) {
        ItemStack is = event.getItemInHand();
        if (!is.getType().equals((Object)Material.FLOWER_POT) || !is.hasItemMeta()) {
            return;
        }
        ItemMeta im = is.getItemMeta();
        if (im.hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Sonic Generator")) {
            Player p = event.getPlayer();
            String uuid = p.getUniqueId().toString();
            Block block = event.getBlock();
            TARDISDisplayItemUtils.set(TARDISDisplayItem.SONIC_GENERATOR, block, -1);
            String l = block.getLocation().toString();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid);
            ResultSetTravellers rs = new ResultSetTravellers(this.plugin, where, false);
            if (rs.resultSet()) {
                this.plugin.getQueryFactory().insertSyncControl(rs.getTardis_id(), 24, l, 0);
                HashMap<String, Object> wheres = new HashMap<String, Object>();
                wheres.put("uuid", event.getPlayer().getUniqueId().toString());
                ResultSetSonic rss = new ResultSetSonic(this.plugin, wheres);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("activated", 1);
                if (rss.resultSet()) {
                    if (!rss.getSonic().isActivated()) {
                        HashMap<String, Object> wherea = new HashMap<String, Object>();
                        wherea.put("uuid", uuid);
                        this.plugin.getQueryFactory().doUpdate("sonic", set, wherea);
                    }
                } else {
                    set.put("uuid", uuid);
                    this.plugin.getQueryFactory().doInsert("sonic", set);
                }
            } else {
                event.setCancelled(true);
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "NOT_IN_TARDIS");
            }
        }
    }
}

