/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.SonicVariant;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisArtron;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.recipes.shaped.SonicScrewdriverRecipe;
import me.eccentric_nz.TARDIS.sonic.TARDISSonicGeneratorInventory;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.util.Vector;

public class TARDISSonicGeneratorMenuListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<String, Integer> costs;
    private final HashMap<String, String> fields;
    private Location location;

    public TARDISSonicGeneratorMenuListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.costs = this.getCosts();
        this.fields = this.getFields();
    }

    private HashMap<String, Integer> getCosts() {
        double full = this.plugin.getArtronConfig().getDouble("full_charge") / 100.0;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("Standard Sonic", (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.standard") * full));
        map.put("Bio-scanner Upgrade", (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.bio") * full));
        map.put("Redstone Upgrade", (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.redstone") * full));
        map.put("Diamond Upgrade", (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.diamond") * full));
        map.put("Emerald Upgrade", (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.emerald") * full));
        map.put("Painter Upgrade", (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.painter") * full));
        map.put("Ignite Upgrade", (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.ignite") * full));
        map.put("Pickup Arrows Upgrade", (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.arrow") * full));
        map.put("Knockback Upgrade", (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.knockback") * full));
        map.put("Brush Upgrade", (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.brush") * full));
        map.put("Conversion Upgrade", (int)(this.plugin.getArtronConfig().getDouble("sonic_generator.conversion") * full));
        return map;
    }

    private HashMap<String, String> getFields() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Bio-scanner Upgrade", "bio");
        map.put("Redstone Upgrade", "redstone");
        map.put("Diamond Upgrade", "diamond");
        map.put("Emerald Upgrade", "emerald");
        map.put("Painter Upgrade", "painter");
        map.put("Ignite Upgrade", "ignite");
        map.put("Pickup Arrows Upgrade", "arrow");
        map.put("Knockback Upgrade", "knockback");
        map.put("Brush Upgrade", "brush");
        map.put("Conversion Upgrade", "conversion");
        return map;
    }

    @EventHandler(ignoreCancelled=true)
    public void onGeneratorMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISSonicGeneratorInventory)) {
            return;
        }
        Player p = (Player)event.getWhoClicked();
        this.location = this.plugin.getTrackerKeeper().getSonicGenerators().get(p.getUniqueId());
        int slot = event.getRawSlot();
        boolean slotWasNull = false;
        if (slot < 0 || slot > 53) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                this.plugin.debug("TARDISSonicGeneratorMenuListener");
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(true);
        InventoryView view = event.getView();
        switch (slot) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                ItemStack sonic = view.getItem(49);
                if (sonic == null) {
                    sonic = ItemStack.of((Material)Material.BLAZE_ROD, (int)1);
                    slotWasNull = true;
                }
                ItemStack choice = view.getItem(slot);
                ItemMeta choice_im = choice.getItemMeta();
                ItemMeta sonic_im = sonic.getItemMeta();
                sonic_im.setCustomModelDataComponent(choice_im.getCustomModelDataComponent());
                sonic.setItemMeta(sonic_im);
                if (!slotWasNull) break;
                view.setItem(49, sonic);
                this.setCost(view, this.costs.get("Standard Sonic"));
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                ArrayList<Object> lore;
                ItemMeta sonic_im;
                ItemStack upgrade = view.getItem(slot);
                ItemMeta upgrade_im = upgrade.getItemMeta();
                Component upgrade_name = upgrade_im.displayName();
                ItemStack sonic = view.getItem(49);
                if (sonic == null) {
                    sonic = ItemStack.of((Material)Material.BLAZE_ROD, (int)1);
                    slotWasNull = true;
                }
                if ((sonic_im = sonic.getItemMeta()).hasLore()) {
                    lore = sonic_im.lore();
                } else {
                    lore = new ArrayList<Object>();
                    lore.add(Component.text((String)"Upgrades:"));
                }
                if (lore != null && !lore.contains(upgrade_name)) {
                    lore.add(upgrade_name);
                    sonic_im.lore(lore);
                    this.setCost(view, this.getCost(view) + this.costs.get(ComponentUtils.stripColour(upgrade_name)));
                }
                sonic.setItemMeta(sonic_im);
                if (!slotWasNull) break;
                view.setItem(49, sonic);
                break;
            }
            case 36: {
                ItemStack sonic = view.getItem(49);
                if (sonic == null) {
                    sonic = ItemStack.of((Material)Material.BLAZE_ROD, (int)1);
                    slotWasNull = true;
                }
                ItemMeta sonic_im = sonic.getItemMeta();
                if (slotWasNull) {
                    sonic_im.displayName((Component)ComponentUtils.toWhite("Sonic Screwdriver"));
                    view.setItem(49, sonic);
                } else {
                    sonic_im.lore(null);
                }
                List<Float> sonicModel = SonicScrewdriverRecipe.sonicModelLookup.getOrDefault(this.plugin.getConfig().getString("sonic.default_model").toLowerCase(Locale.ROOT), SonicVariant.ELEVENTH.getFloats());
                CustomModelDataComponent component = sonic_im.getCustomModelDataComponent();
                component.setFloats(sonicModel);
                sonic_im.setCustomModelDataComponent(component);
                sonic.setItemMeta(sonic_im);
                this.setCost(view, this.costs.get("Standard Sonic"));
                break;
            }
            case 43: {
                ItemStack sonic = view.getItem(49);
                if (sonic == null) break;
                this.save(p, sonic, true);
                break;
            }
            case 44: {
                ItemStack sonic = view.getItem(49);
                if (sonic == null) break;
                this.save(p, sonic, false);
                this.generate(p, sonic, this.getCost(view));
                break;
            }
            case 53: {
                this.close(p);
                break;
            }
        }
    }

    private void save(Player p, ItemStack is, boolean close) {
        HashMap<String, Object> set = new HashMap<String, Object>();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", p.getUniqueId().toString());
        where.put("activated", 1);
        ItemMeta im = is.getItemMeta();
        String split = im.getItemModel().getKey().replace("sonic/", "");
        set.put("model", split);
        if (im.hasLore()) {
            List lore = im.lore();
            this.fields.forEach((key, value) -> set.put((String)value, lore != null && lore.contains(Component.text((String)key)) ? 1 : 0));
        } else {
            this.fields.forEach((key, value) -> set.put((String)value, 0));
        }
        this.plugin.getQueryFactory().doUpdate("sonic", set, where);
        this.plugin.getTrackerKeeper().getSonicGenerators().remove(p.getUniqueId());
        if (close) {
            this.close(p);
        }
    }

    private void generate(Player p, ItemStack sonic, int cost) {
        ResultSetTardisArtron rs = new ResultSetTardisArtron(this.plugin);
        if (rs.fromUUID(p.getUniqueId().toString())) {
            int level = rs.getArtronLevel();
            if (cost < level) {
                ItemStack is = sonic.clone();
                Location loc = this.location.clone().add(0.5, 0.75, 0.5);
                Item drop = this.location.getWorld().dropItem(loc, is);
                drop.setVelocity(new Vector(0, 0, 0));
                this.plugin.getTrackerKeeper().getSonicGenerators().remove(p.getUniqueId());
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", p.getUniqueId().toString());
                this.plugin.getQueryFactory().alterEnergyLevel("tardis", -cost, where, p);
            } else {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "UPGRADE_ABORT_ENERGY");
            }
        }
        this.close(p);
    }

    private int getCost(InventoryView view) {
        ItemStack is = view.getItem(45);
        ItemMeta im = is.getItemMeta();
        String c = ComponentUtils.stripColour((Component)im.lore().getFirst());
        return TARDISNumberParsers.parseInt(c);
    }

    private void setCost(InventoryView view, int cost) {
        ItemStack is = view.getItem(45);
        ItemMeta im = is.getItemMeta();
        List lore = im.lore();
        lore.set(0, Component.text((int)cost));
        im.lore(lore);
        is.setItemMeta(im);
    }
}

