/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel.save;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class TARDISDeathLocation {
    private final TARDIS plugin;

    public TARDISDeathLocation(TARDIS plugin) {
        this.plugin = plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(Player player, Location location) {
        TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
        Connection connection = service.getConnection();
        String uuid = player.getUniqueId().toString();
        Statement statement = null;
        try {
            service.testConnection(connection);
            statement = connection.createStatement();
            String select = "SELECT uuid FROM " + this.plugin.getPrefix() + "deaths WHERE uuid = '" + uuid + "'";
            ResultSet rs = statement.executeQuery(select);
            HashMap<String, Object> set = new HashMap<String, Object>();
            if (location == null) {
                set.put("world", "Could not be saved!");
                return;
            }
            set.put("world", location.getWorld().getName());
            set.put("x", location.getBlockX());
            set.put("y", location.getBlockY());
            set.put("z", location.getBlockZ());
            COMPASS player_d = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(player, false));
            set.put("direction", player_d.toString());
            set.put("submarine", this.isSub(location) ? 1 : 0);
            if (rs.isBeforeFirst()) {
                HashMap<String, Object> uid = new HashMap<String, Object>();
                uid.put("uuid", uuid);
                this.plugin.getQueryFactory().doUpdate("deaths", set, uid);
            } else {
                set.put("uuid", uuid);
                this.plugin.getQueryFactory().doInsert("deaths", set);
            }
        }
        catch (SQLException e) {
            this.plugin.debug("Upsert deaths error! " + e.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing upsert deaths statement! " + e.getMessage());
            }
        }
    }

    private boolean isSub(Location l) {
        return l.getBlock().getType().equals((Object)Material.WATER);
    }

    public Location getLocation(Player player) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", player.getUniqueId().toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, false);
        if (rst.resultSet()) {
            return null;
        }
        Location location = player.getLocation();
        if (this.plugin.getTardisArea().isInExistingArea(location)) {
            return null;
        }
        String world = location.getWorld().getName();
        if (!this.plugin.getConfig().getBoolean("travel.include_default_world") && this.plugin.getConfig().getBoolean("creation.default_world") && world.equals(this.plugin.getConfig().getString("creation.default_world_name"))) {
            return null;
        }
        if (!this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".time_travel")) {
            return null;
        }
        if (!this.plugin.getPluginRespect().getRespect(location, new Parameters(player, Flag.getDefaultFlags()))) {
            return null;
        }
        Block b = location.getBlock();
        boolean unsafe = true;
        while (unsafe) {
            boolean clear = true;
            for (BlockFace f : this.plugin.getGeneralKeeper().getSurrounding()) {
                if (TARDISConstants.GOOD_MATERIALS.contains(b.getRelative(f).getType())) continue;
                b = b.getRelative(BlockFace.UP);
                clear = false;
                break;
            }
            unsafe = !clear;
        }
        location.setY((double)b.getY());
        return location;
    }
}

