/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.tardischemistry.compound.Compound;
import me.eccentric_nz.tardischemistry.lab.Lab;
import me.eccentric_nz.tardischemistry.product.Product;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TARDISChemistryTabComplete
extends TARDISCompleter
implements TabCompleter {
    private final List<String> ROOT_SUBS = List.of("gui", "formula", "recipe");
    private final List<String> GUI_SUBS = List.of("creative", "construct", "compound", "reduce", "product", "lab");
    private final List<String> FORMULA_SUBS = new ArrayList<String>();
    private final List<String> CREATIVE_SUBS = List.of("elements", "compounds", "products", "lab");

    public TARDISChemistryTabComplete() {
        for (Compound compound : Compound.values()) {
            this.FORMULA_SUBS.add(compound.toString());
        }
        for (Enum enum_ : Product.values()) {
            this.FORMULA_SUBS.add(enum_.toString());
        }
        for (Enum enum_ : Lab.values()) {
            this.FORMULA_SUBS.add(enum_.toString());
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            return this.partial(args[0], this.ROOT_SUBS);
        }
        if (args.length == 2) {
            String sub = args[0].toLowerCase(Locale.ROOT);
            if (sub.equals("gui") || sub.equals("recipe")) {
                return this.partial(lastArg, this.GUI_SUBS);
            }
            if (sub.equals("formula")) {
                return this.partial(lastArg, this.FORMULA_SUBS);
            }
        } else if (args.length == 3) {
            return this.partial(lastArg, this.CREATIVE_SUBS);
        }
        return ImmutableList.of();
    }
}

