/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.microscope;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardischemistry.microscope.LabEquipment;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class MicroscopeDamageListener
implements Listener {
    private final TARDIS plugin;

    MicroscopeDamageListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onDamageEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            if (!frame.getPersistentDataContainer().has(this.plugin.getMicroscopeKey(), PersistentDataType.INTEGER)) {
                return;
            }
            event.setCancelled(true);
            ItemStack dye = frame.getItem();
            if (dye.getType().isAir()) {
                return;
            }
            if (!LabEquipment.getByMaterial().containsKey(dye.getType())) {
                return;
            }
            Entity entity2 = event.getDamager();
            if (entity2 instanceof Player) {
                Player player = (Player)entity2;
                LabEquipment equipment = LabEquipment.getByMaterial().get(dye.getType());
                ItemStack drop = ItemStack.of((Material)equipment.getMaterial(), (int)1);
                ItemMeta dropMeta = drop.getItemMeta();
                dropMeta.displayName((Component)Component.text((String)equipment.getName()));
                dropMeta.setItemModel(equipment.getModel());
                drop.setItemMeta(dropMeta);
                player.getWorld().dropItem(entity.getLocation(), drop);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((ItemFrame)frame).remove(), 1L);
            }
        }
    }
}

