/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.custombiome;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardischunkgenerator.TARDISHelper;
import me.eccentric_nz.tardischunkgenerator.custombiome.BiomeHelper;
import me.eccentric_nz.tardischunkgenerator.custombiome.CustomBiomeData;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import org.bukkit.command.CommandSender;

public class CustomBiome {
    public static void addCustomBiome(CustomBiomeData data) {
        ResourceKey minecraftKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)data.minecraftName()));
        ResourceKey customKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tardis", (String)data.customName()));
        WritableRegistry registrywritable = (WritableRegistry)BiomeHelper.getRegistry();
        Biome minecraftbiome = (Biome)registrywritable.getValueOrThrow(minecraftKey);
        Biome.BiomeBuilder newBiome = new Biome.BiomeBuilder();
        newBiome.downfall(minecraftbiome.climateSettings.downfall());
        MobSpawnSettings biomeSettingMobs = minecraftbiome.getMobSettings();
        newBiome.mobSpawnSettings(biomeSettingMobs);
        BiomeGenerationSettings biomeSettingGen = minecraftbiome.getGenerationSettings();
        newBiome.generationSettings(biomeSettingGen);
        newBiome.temperature(data.temperature());
        newBiome.downfall(data.downfall());
        newBiome.temperatureAdjustment(data.frozen() ? Biome.TemperatureModifier.NONE : Biome.TemperatureModifier.FROZEN);
        BiomeSpecialEffects.Builder newFog = new BiomeSpecialEffects.Builder();
        newFog.grassColorModifier(BiomeSpecialEffects.GrassColorModifier.NONE);
        newFog.fogColor(data.fogColour());
        newFog.waterColor(data.waterColour());
        newFog.waterFogColor(data.waterFogColour());
        newFog.skyColor(data.skyColour());
        newFog.foliageColorOverride(data.foliageColour());
        newFog.grassColorOverride(data.grassColour());
        if (data.particle() != null) {
            newFog.ambientParticle(new AmbientParticleSettings((ParticleOptions)data.particle(), data.ambience()));
        }
        newBiome.specialEffects(newFog.build());
        Biome biome = newBiome.build();
        try {
            TARDISHelper.biomeMap.put(data.customName(), biome);
            Field frozen = MappedRegistry.class.getDeclaredField("frozen");
            frozen.setAccessible(true);
            frozen.set(registrywritable, false);
            Field unregisteredIntrusiveHolders = MappedRegistry.class.getDeclaredField("unregisteredIntrusiveHolders");
            unregisteredIntrusiveHolders.setAccessible(true);
            unregisteredIntrusiveHolders.set(registrywritable, new IdentityHashMap());
            registrywritable.createIntrusiveHolder((Object)biome);
            Holder.Reference holder = registrywritable.register(customKey, (Object)biome, RegistrationInfo.BUILT_IN);
            HashSet tags = new HashSet();
            Holder minecraftHolder = Holder.direct((Object)minecraftbiome);
            minecraftHolder.tags().forEach(tags::add);
            Method bindTags = Holder.Reference.class.getDeclaredMethod("bindTags", Collection.class);
            bindTags.setAccessible(true);
            bindTags.invoke((Object)holder, tags);
            unregisteredIntrusiveHolders.set(registrywritable, null);
            frozen.setAccessible(true);
            frozen.set(registrywritable, true);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ignored) {
            TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.WARNING, "Could not unlock biome registry!");
        }
    }
}

