/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen;

import java.util.Locale;
import java.util.Random;
import java.util.logging.Level;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardischunkgenerator.worldgen.biomeproviders.FlatBiomeProvider;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Gate;
import org.bukkit.block.data.type.Sign;
import org.bukkit.block.data.type.Wall;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;

public class PlotGenerator
extends ChunkGenerator {
    private final Wall wall_EW;
    private final Wall wall_NS;
    private final Wall wall_NW;
    private final Wall wall_NE;
    private final Wall wall_SW;
    private final Wall wall_SE;
    private final Gate gate_EW;
    private final Gate gate_NS;
    private final Sign angled;
    private final int size;
    private Material rock;
    private Material middle;
    private Material surface;
    private Material road_side;
    private Material road_line;

    public PlotGenerator(TARDIS plugin) {
        Material sign;
        Material gate;
        Material wall;
        try {
            this.rock = Material.valueOf((String)plugin.getGeneratorConfig().getString("plot.rock", "STONE").toUpperCase(Locale.ROOT));
            this.middle = Material.valueOf((String)plugin.getGeneratorConfig().getString("plot.middle", "DIRT").toUpperCase(Locale.ROOT));
            this.surface = Material.valueOf((String)plugin.getGeneratorConfig().getString("plot.surface", "GRASS_BLOCK").toUpperCase(Locale.ROOT));
            wall = Material.valueOf((String)plugin.getGeneratorConfig().getString("plot.wall", "RESIN_BLOCK_WALL").toUpperCase(Locale.ROOT));
            if (!(wall.createBlockData() instanceof Wall)) {
                plugin.getLogger().log(Level.INFO, "Specified wall material is not a wall!");
                plugin.getLogger().log(Level.INFO, "Using default wall.");
                wall = Material.RESIN_BRICK_WALL;
            }
            if (!((gate = Material.valueOf((String)plugin.getGeneratorConfig().getString("plot.gate", "BAMBOO_FENCE_GATE").toUpperCase(Locale.ROOT))).createBlockData() instanceof Gate)) {
                plugin.getLogger().log(Level.INFO, "Specified gate material is not a gate!");
                plugin.getLogger().log(Level.INFO, "Using default gate.");
                gate = Material.BAMBOO_FENCE_GATE;
            }
            if (!((sign = Material.valueOf((String)plugin.getGeneratorConfig().getString("plot.sign", "BAMBOO_SIGN").toUpperCase(Locale.ROOT))).createBlockData() instanceof Sign)) {
                sign = Material.BAMBOO_SIGN;
            }
            this.road_side = Material.valueOf((String)plugin.getGeneratorConfig().getString("plot.road_side", "GRAY_CONCRETE").toUpperCase(Locale.ROOT));
            this.road_line = Material.valueOf((String)plugin.getGeneratorConfig().getString("plot.road_line", "WHITE_CONCRETE").toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            plugin.getLogger().log(Level.WARNING, "Invalid material specified! " + e.getMessage());
            plugin.getLogger().log(Level.INFO, "Using default materials.");
            this.rock = Material.STONE;
            this.middle = Material.DIRT;
            this.surface = Material.GRASS_BLOCK;
            wall = Material.RESIN_BRICK_WALL;
            gate = Material.BAMBOO_FENCE_GATE;
            sign = Material.BAMBOO_SIGN;
            this.road_side = Material.GRAY_CONCRETE;
            this.road_line = Material.WHITE_CONCRETE;
        }
        this.wall_EW = (Wall)wall.createBlockData("[east=low,west=low,up=false]");
        this.wall_NS = (Wall)wall.createBlockData("[north=low,south=low,up=false]");
        this.wall_NE = (Wall)wall.createBlockData("[north=low,east=low]");
        this.wall_NW = (Wall)wall.createBlockData("[north=low,west=low]");
        this.wall_SE = (Wall)wall.createBlockData("[east=low,south=low]");
        this.wall_SW = (Wall)wall.createBlockData("[west=low,south=low]");
        this.gate_EW = (Gate)gate.createBlockData("[in_wall=true,facing=east]");
        this.gate_NS = (Gate)gate.createBlockData("[in_wall=true,facing=north]");
        this.angled = (Sign)sign.createBlockData("[rotation=6]");
        this.size = Math.max(plugin.getGeneratorConfig().getInt("plot.size"), 2);
    }

    public void generateSurface(WorldInfo worldInfo, Random random, int x, int z, ChunkGenerator.ChunkData chunkData) {
        if (chunkData.getMinHeight() == worldInfo.getMinHeight()) {
            boolean isTopLeft = Math.floorMod(x, this.size) == 0 && Math.floorMod(z, this.size) == 0;
            for (int bx = 0; bx < 16; ++bx) {
                for (int bz = 0; bz < 16; ++bz) {
                    for (int by = 1; by <= 65; ++by) {
                        if (by < 60) {
                            chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, this.rock);
                            continue;
                        }
                        if (by < 64) {
                            chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, this.middle);
                            continue;
                        }
                        if (by == 64) {
                            if (isTopLeft) {
                                if (bx < 2 || bx > 2 && bx < 5 || bz < 2 || bz > 2 && bz < 5) {
                                    chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, this.road_side);
                                    continue;
                                }
                                if (bx == 2) {
                                    chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, bz % 4 > 1 ? this.road_side : this.road_line);
                                    continue;
                                }
                                if (bz == 2) {
                                    chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, bx % 4 > 1 ? this.road_side : this.road_line);
                                    continue;
                                }
                                chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, this.surface);
                                continue;
                            }
                            if (Math.floorMod(x, this.size) == 0) {
                                if (bx < 2 || bx > 2 && bx < 5) {
                                    chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, this.road_side);
                                    continue;
                                }
                                if (bx == 2) {
                                    chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, bz % 4 > 1 ? this.road_side : this.road_line);
                                    continue;
                                }
                                chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, this.surface);
                                continue;
                            }
                            if (Math.floorMod(z, this.size) == 0) {
                                if (bz < 2 || bz > 2 && bz < 5) {
                                    chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, this.road_side);
                                    continue;
                                }
                                if (bz == 2) {
                                    chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, bx % 4 > 1 ? this.road_side : this.road_line);
                                    continue;
                                }
                                chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, this.surface);
                                continue;
                            }
                            chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, this.surface);
                            continue;
                        }
                        if (isTopLeft) {
                            if (bx == 5 && bz == 5) {
                                chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)this.wall_SE);
                                continue;
                            }
                            if (bx > 5 && bz == 5) {
                                chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)(bx == 10 ? this.gate_NS : this.wall_EW));
                            }
                            if (bz <= 5 || bx != 5) continue;
                            chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)(bz == 10 ? this.gate_EW : this.wall_NS));
                            continue;
                        }
                        if (Math.floorMod(x, this.size) == this.size - 1 && Math.floorMod(z, this.size) == this.size - 1) {
                            if (bx == 15 && bz == 15) {
                                chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)this.wall_NW);
                                continue;
                            }
                            if (bx == 15) {
                                chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)(bz == 7 ? this.gate_EW : this.wall_NS));
                            }
                            if (bz != 15) continue;
                            chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)(bx == 7 ? this.gate_NS : this.wall_EW));
                            continue;
                        }
                        if (Math.floorMod(x, this.size) == 0 && Math.floorMod(z, this.size) == this.size - 1) {
                            if (bx == 5 && bz == 15) {
                                chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)this.wall_NE);
                                continue;
                            }
                            if (bx == 5) {
                                chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)(bz == 10 ? this.gate_EW : this.wall_NS));
                            }
                            if (bx <= 5 || bz != 15) continue;
                            chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)(bx == 10 ? this.gate_NS : this.wall_EW));
                            continue;
                        }
                        if (Math.floorMod(x, this.size) == this.size - 1 && Math.floorMod(z, this.size) == 0) {
                            if (bz == 5 && bx == 15) {
                                chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)this.wall_SW);
                                continue;
                            }
                            if (bz == 5) {
                                chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)(bx == 7 ? this.gate_NS : this.wall_EW));
                                continue;
                            }
                            if (bz <= 5 || bx != 15) continue;
                            chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)(bz == 10 ? this.gate_EW : this.wall_NS));
                            continue;
                        }
                        if (Math.floorMod(x, this.size) == 0) {
                            if (bx != 5) continue;
                            chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)(bz == 7 ? this.gate_EW : this.wall_NS));
                            continue;
                        }
                        if (Math.floorMod(z, this.size) == 0) {
                            if (bz != 5) continue;
                            chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)(bx == 7 ? this.gate_NS : this.wall_EW));
                            continue;
                        }
                        if (Math.floorMod(x, this.size) == this.size - 1) {
                            if (bx != 15) continue;
                            chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)(bz == 7 ? this.gate_EW : this.wall_NS));
                            continue;
                        }
                        if (Math.floorMod(z, this.size) != this.size - 1 || bz != 15) continue;
                        chunkData.setBlock(bx, chunkData.getMinHeight() + by, bz, (BlockData)(bx == 7 ? this.gate_NS : this.wall_EW));
                    }
                    if (!isTopLeft) continue;
                    chunkData.setBlock(5, chunkData.getMinHeight() + 66, 5, (BlockData)this.angled);
                }
            }
        }
    }

    public void generateBedrock(WorldInfo worldInfo, Random random, int x, int z, ChunkGenerator.ChunkData chunkData) {
        if (chunkData.getMinHeight() == worldInfo.getMinHeight()) {
            for (int bx = 0; bx < 16; ++bx) {
                for (int bz = 0; bz < 16; ++bz) {
                    chunkData.setBlock(bx, chunkData.getMinHeight(), bz, Material.BEDROCK);
                }
            }
        }
    }

    public BiomeProvider getDefaultBiomeProvider(WorldInfo worldInfo) {
        return new FlatBiomeProvider();
    }

    public Location getFixedSpawnLocation(World world, Random random) {
        return new Location(world, 0.0, 65.0, 0.0);
    }

    public boolean shouldGenerateNoise() {
        return false;
    }

    public boolean shouldGenerateSurface() {
        return true;
    }

    public boolean shouldGenerateCaves() {
        return false;
    }

    public boolean shouldGenerateDecorations() {
        return false;
    }

    public boolean shouldGenerateMobs() {
        return false;
    }

    public boolean shouldGenerateStructures() {
        return false;
    }
}

