/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen.utils;

import com.mojang.datafixers.util.Pair;
import java.util.Random;

public class IslandSpiral {
    private Pair<Integer, Integer> treePosition;

    public double[][] createMatrix(int rows, int cols, Random random, double increment) {
        double[][] arr = new double[rows][cols];
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                arr[r][c] = 0.0;
            }
        }
        int top = 1;
        int bottom = rows - 2;
        int left = 1;
        int right = cols - 2;
        double height = 0.0;
        int change = random.nextInt(12) + 4;
        int counter = 0;
        int t = random.nextInt((rows - 2) * (cols - 2) - 24) + 24;
        Direction dir = Direction.RIGHT;
        block7: while (top <= bottom && left <= right) {
            int i;
            switch (dir.ordinal()) {
                case 0: {
                    for (i = left; i <= right; ++i) {
                        if (counter % change == 0) {
                            height += increment;
                            change = random.nextInt(12) + 4;
                        }
                        arr[top][i] = height;
                        if (counter == t) {
                            this.treePosition = new Pair((Object)top, (Object)i);
                        }
                        ++counter;
                    }
                    ++top;
                    dir = Direction.DOWN;
                    continue block7;
                }
                case 1: {
                    for (i = top; i <= bottom; ++i) {
                        if (counter % change == 0) {
                            height += increment;
                            change = random.nextInt(12) + 4;
                        }
                        arr[i][right] = height;
                        if (counter == t) {
                            this.treePosition = new Pair((Object)i, (Object)right);
                        }
                        ++counter;
                    }
                    --right;
                    dir = Direction.LEFT;
                    continue block7;
                }
                case 2: {
                    for (i = right; i >= left; --i) {
                        if (counter % change == 0) {
                            height += increment;
                            change = random.nextInt(12) + 4;
                        }
                        arr[bottom][i] = height;
                        if (counter == t) {
                            this.treePosition = new Pair((Object)bottom, (Object)i);
                        }
                        ++counter;
                    }
                    --bottom;
                    dir = Direction.UP;
                    continue block7;
                }
            }
            for (i = bottom; i >= top; --i) {
                if (counter % change == 0) {
                    height += increment;
                    change = random.nextInt(12) + 4;
                }
                arr[i][left] = height;
                if (counter == t) {
                    this.treePosition = new Pair((Object)i, (Object)left);
                }
                ++counter;
            }
            ++left;
            dir = Direction.RIGHT;
        }
        return arr;
    }

    public Pair<Integer, Integer> getTreePosition() {
        return this.treePosition;
    }

    public static enum Direction {
        RIGHT,
        DOWN,
        LEFT,
        UP;

    }
}

