/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisshop;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardisshop.TARDISShopItem;
import me.eccentric_nz.tardisshop.database.InsertShopItem;
import me.eccentric_nz.tardisshop.database.ResultSetUpdateShop;
import me.eccentric_nz.tardisshop.database.UpdateShopItem;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;

public class TARDISShopCommand
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final ImmutableList<String> ROOT_SUBS = ImmutableList.of((Object)"add", (Object)"remove", (Object)"update");
    private final List<String> ITEM_SUBS;

    public TARDISShopCommand(TARDIS plugin) {
        this.plugin = plugin;
        this.ITEM_SUBS = new ArrayList<String>(this.plugin.getItemsConfig().getKeys(false));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisshop")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.length < 1) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.SHOP, "TOO_FEW_ARGS");
                    return true;
                }
                if (args[0].equalsIgnoreCase("remove")) {
                    this.plugin.getShopSettings().getRemovingItem().add(player.getUniqueId());
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.SHOP, "SHOP_REMOVE", this.plugin.getShopSettings().getBlockMaterial().toString());
                    return true;
                }
                if (args[0].equalsIgnoreCase("update")) {
                    File file = new File(this.plugin.getDataFolder(), "items.yml");
                    try {
                        this.plugin.getItemsConfig().load(file);
                    }
                    catch (IOException | InvalidConfigurationException e) {
                        this.plugin.debug("Failed to reload items.yml" + e.getMessage());
                    }
                    ResultSetUpdateShop rs = new ResultSetUpdateShop(this.plugin);
                    if (rs.getAll()) {
                        for (TARDISShopItem item : rs.getShopItems()) {
                            String lookup = item.item().replace(" ", "_").toLowerCase(Locale.ROOT);
                            double cost = this.plugin.getItemsConfig().getDouble(lookup);
                            if (cost == item.cost()) continue;
                            new UpdateShopItem(this.plugin).updateCost(cost, item.id());
                            for (Entity e : item.location().getWorld().getNearbyEntities(item.location().add(0.5, 1.0, 0.5), 0.5, 1.0, 0.5)) {
                                if (!(e instanceof TextDisplay)) continue;
                                TextDisplay text = (TextDisplay)e;
                                text.text(((TextComponent)Component.text((String)(item.item() + "\n")).append((Component)Component.text((String)"Cost:", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)String.format(" %.2f", cost), (TextColor)NamedTextColor.WHITE)));
                            }
                        }
                    }
                    return true;
                }
                if (args.length < 2) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.SHOP, "TOO_FEW_ARGS");
                    return true;
                }
                if (args[0].equalsIgnoreCase("add")) {
                    String name = args[1].toLowerCase(Locale.ROOT);
                    if (!this.plugin.getItemsConfig().contains(name)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.SHOP, "TOO_FEW_ARGS");
                        return true;
                    }
                    double cost = this.plugin.getItemsConfig().getDouble(name);
                    TARDISShopItem item = new InsertShopItem(this.plugin).addNamedItem(TARDISStringUtils.capitalise(args[1]), cost);
                    this.plugin.getShopSettings().getSettingItem().put(player.getUniqueId(), item);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.SHOP, "SHOP_ADD", this.plugin.getShopSettings().getBlockMaterial().toString());
                    return true;
                }
                return true;
            }
            this.plugin.getMessenger().send(sender, TardisModule.SHOP, "CMD_NO_CONSOLE");
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            return this.partial(args[0], (Collection<String>)this.ROOT_SUBS);
        }
        if (args.length == 2 && (sub = args[0]).equalsIgnoreCase("add")) {
            return this.partial(lastArg, this.ITEM_SUBS);
        }
        return ImmutableList.of();
    }
}

