/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisvortexmanipulator.TVMUtils;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMQueryFactory;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class TVMCommandLifesigns {
    private final TARDIS plugin;

    public TVMCommandLifesigns(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean scan(Player player, String[] args) {
        if (!TARDISPermission.hasPermission(player, "vm.lifesigns")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PERM_CMD");
            return true;
        }
        int required = this.plugin.getVortexConfig().getInt("tachyon_use.lifesigns");
        if (!TVMUtils.checkTachyonLevel(player.getUniqueId().toString(), required)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_LIFESIGNS_TACHYON");
            return true;
        }
        new TVMQueryFactory(this.plugin).alterTachyons(player.getUniqueId().toString(), -required);
        if (args.length == 1) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "SCAN_ENTS");
            double d = this.plugin.getVortexConfig().getDouble("lifesign_scan_distance");
            List ents = player.getNearbyEntities(d, d, d);
            if (!ents.isEmpty()) {
                HashMap<EntityType, Integer> scannedEntities = new HashMap<EntityType, Integer>();
                ArrayList<String> playernames = new ArrayList<String>();
                for (Entity entity : ents) {
                    EntityType et = entity.getType();
                    if (!TARDISConstants.ENTITY_TYPES.contains(et)) continue;
                    int entity_count = scannedEntities.getOrDefault(et, 0);
                    boolean visible = true;
                    if (et.equals((Object)EntityType.PLAYER)) {
                        Player entPlayer = (Player)entity;
                        if (player.canSee(entPlayer)) {
                            playernames.add(entPlayer.getName());
                        } else {
                            visible = false;
                        }
                    }
                    if (!visible) continue;
                    scannedEntities.put(et, entity_count + 1);
                }
                for (Map.Entry entry : scannedEntities.entrySet()) {
                    Object message = "";
                    StringBuilder buf = new StringBuilder();
                    if (((EntityType)entry.getKey()).equals((Object)EntityType.PLAYER) && !playernames.isEmpty()) {
                        playernames.forEach(pn -> buf.append(", ").append((String)pn));
                        message = " (" + buf.substring(2) + ")";
                    }
                    player.sendMessage("    " + String.valueOf(entry.getKey()) + ": " + String.valueOf(entry.getValue()) + (String)message);
                }
                scannedEntities.clear();
            } else {
                player.sendMessage("SCAN_NONE");
            }
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PLAYER");
            return true;
        }
        Player scanned = this.plugin.getServer().getPlayer(args[1]);
        if (scanned == null) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "COULD_NOT_FIND_NAME");
            return true;
        }
        if (!scanned.isOnline()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_NOT_ONLINE", args[1]);
            return true;
        }
        double health = scanned.getHealth() / scanned.getAttribute(Attribute.MAX_HEALTH).getValue() * scanned.getHealthScale();
        float hunger = (float)scanned.getFoodLevel() / 20.0f * 100.0f;
        int air = scanned.getRemainingAir();
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_LIFESIGNS", args[1]);
        player.sendMessage("Has been alive for: " + TVMUtils.convertTicksToTime(scanned.getTicksLived()));
        player.sendMessage("Health: " + String.format("%.1f", health / 2.0) + " hearts");
        player.sendMessage("Hunger bar: " + String.format("%.2f", Float.valueOf(hunger)) + "%");
        player.sendMessage("Air: ~" + air / 20 + " seconds remaining");
        return true;
    }
}

