/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.command;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisvortexmanipulator.TVMUtils;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetSaves;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetWarpByName;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TVMCommandSave {
    private final TARDIS plugin;

    public TVMCommandSave(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean process(Player player, String[] args) {
        if (!TARDISPermission.hasPermission(player, "vm.teleport")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PERM_CMD");
            return true;
        }
        String uuid = player.getUniqueId().toString();
        if (args.length == 1) {
            TVMResultSetSaves rss = new TVMResultSetSaves(this.plugin, uuid, 0, 10);
            if (rss.resultSet()) {
                TVMUtils.sendSaveList(player, rss, 1);
            }
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PAGE_NUM");
            return true;
        }
        try {
            int page = Integer.parseInt(args[1]);
            if (page <= 0) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_MSG_INVALID");
                return true;
            }
            int start = page * 10 - 10;
            int limit = page * 10;
            TVMResultSetSaves rss = new TVMResultSetSaves(this.plugin, uuid, start, limit);
            if (rss.resultSet()) {
                TVMUtils.sendSaveList(player, rss, page);
            }
            return true;
        }
        catch (NumberFormatException e) {
            this.plugin.debug("Wasn't a page number...");
            TVMResultSetWarpByName rs = new TVMResultSetWarpByName(this.plugin, uuid, args[1]);
            if (rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_SAVE_EXISTS");
                return true;
            }
            Location l = player.getLocation();
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("uuid", uuid);
            set.put("save_name", args[1]);
            set.put("world", l.getWorld().getName());
            set.put("x", l.getX());
            set.put("y", l.getY());
            set.put("z", l.getZ());
            set.put("yaw", Float.valueOf(l.getYaw()));
            set.put("pitch", Float.valueOf(l.getPitch()));
            this.plugin.getQueryFactory().doInsert("saves", set);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_SAVE_ADDED", args[1]);
            return true;
        }
    }
}

