/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.judoon;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.nms.TWAFollower;
import me.eccentric_nz.tardisweepingangels.nms.TWAJudoon;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Snowball;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Vector;

public class JudoonGuardRunnable
implements Runnable {
    private final TARDIS plugin;

    public JudoonGuardRunnable(TARDIS plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        if (!TARDISWeepingAngels.getGuards().isEmpty()) {
            for (UUID uuid : TARDISWeepingAngels.getGuards()) {
                Entity entity = Bukkit.getEntity((UUID)uuid);
                if (entity == null || !entity.getPersistentDataContainer().has(TARDISWeepingAngels.JUDOON, TARDISWeepingAngels.PersistentDataTypeUUID)) {
                    return;
                }
                Location origin = entity.getLocation();
                for (Entity e : entity.getWorld().getNearbyEntities(origin, 8.0, 8.0, 8.0, d -> d instanceof Enemy)) {
                    TWAJudoon judoon;
                    int ammo;
                    if (e == entity || ((CraftEntity)e).getHandle() instanceof TWAFollower) continue;
                    Damageable damageable = (Damageable)e;
                    double health = damageable.getHealth();
                    net.minecraft.world.entity.Entity husk = ((CraftEntity)entity).getHandle();
                    if (!(husk instanceof TWAJudoon) || (ammo = (judoon = (TWAJudoon)husk).getAmmo()) <= 0 || !(health > 0.0)) continue;
                    entity.getWorld().playSound(origin, "judoon_fire", 1.0f, 1.0f);
                    Snowball snowball = (Snowball)((LivingEntity)entity).launchProjectile(Snowball.class);
                    Vector start = origin.toVector();
                    Vector direction = damageable.getLocation().toVector().subtract(start);
                    direction.normalize();
                    Vector bulletVelocity = direction.multiply(3.0);
                    snowball.setVelocity(bulletVelocity);
                    origin.setDirection(direction.subtract(start));
                    float yaw = origin.getYaw();
                    entity.setRotation(yaw, 0.0f);
                    if (--ammo > 0) {
                        entity.customName((Component)Component.text((String)("Ammunition: " + ammo)));
                        entity.setCustomNameVisible(true);
                        judoon.setAmmo(ammo);
                    }
                    BlockIterator iterator = new BlockIterator(entity.getWorld(), start, direction, 0.0, 16);
                    while (iterator.hasNext()) {
                        if (iterator.next().getType().isAir()) continue;
                        return;
                    }
                    damageable.damage(this.plugin.getMonstersConfig().getDouble("judoon.damage"), entity);
                }
            }
        }
    }
}

