/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.k9;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Follower;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.monsters.k9.K9Equipment;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Husk;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class K9Listener
implements Listener {
    private final TARDIS plugin;

    public K9Listener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onWolfTame(EntityTameEvent event) {
        LivingEntity ent = event.getEntity();
        if (!ent.getType().equals((Object)EntityType.WOLF) || !this.plugin.getMonstersConfig().getBoolean("k9.by_taming")) {
            return;
        }
        AnimalTamer animalTamer = event.getOwner();
        if (animalTamer instanceof Player) {
            Player player = (Player)animalTamer;
            if (!TARDISPermission.hasPermission((Player)event.getOwner(), "tardisweepingangels.k9")) {
                return;
            }
            Location location = ent.getLocation();
            if (!this.plugin.getMonstersConfig().getBoolean("k9.worlds." + location.getWorld().getName())) {
                return;
            }
            LivingEntity k9 = (LivingEntity)new MonsterSpawner().createFollower(location, new Follower(UUID.randomUUID(), player.getUniqueId(), Monster.K9)).getBukkitEntity();
            K9Equipment.set((OfflinePlayer)player, k9, false);
            ent.remove();
            player.playSound(k9.getLocation(), "k9", 1.0f, 1.0f);
            this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)k9, EntityType.HUSK, Monster.K9, location));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onDamageK9(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Husk) {
            Husk k9 = (Husk)entity;
            entity = event.getDamager();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (k9.getPersistentDataContainer().has(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID) && k9.getPersistentDataContainer().has(TARDISWeepingAngels.K9, TARDISWeepingAngels.PersistentDataTypeUUID)) {
                    event.setCancelled(true);
                    player.playSound(k9.getLocation(), "k9", 1.0f, 1.0f);
                    UUID k9Id = (UUID)k9.getPersistentDataContainer().get(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID);
                    if (!TARDISPermission.hasPermission(player, "tardisweepingangels.k9")) {
                        return;
                    }
                    if (TARDISWeepingAngels.UNCLAIMED.equals(k9Id)) {
                        k9.getPersistentDataContainer().set(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID, (Object)player.getUniqueId());
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.MONSTERS, "WA_CLAIMED", "K-9");
                    }
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onK9BoneEgg(PlayerInteractEvent event) {
        ItemMeta im;
        ItemStack is;
        if ((event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || event.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) && (is = event.getItem()) != null && is.getType().equals((Object)Material.BONE) && is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "K9") && im.hasItemModel()) {
            event.setCancelled(true);
            Player player = event.getPlayer();
            Location location = event.getClickedBlock().getLocation().add(0.5, 1.0, 0.5);
            if (!this.plugin.getMonstersConfig().getBoolean("k9.worlds." + location.getWorld().getName())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.MONSTERS, "WA_SPAWN");
                return;
            }
            if (is.getAmount() == 1) {
                player.getInventory().setItemInMainHand(null);
            } else {
                is.setAmount(is.getAmount() - 1);
                player.getInventory().setItemInMainHand(is);
            }
            LivingEntity k9 = (LivingEntity)new MonsterSpawner().createFollower(location, new Follower(UUID.randomUUID(), player.getUniqueId(), Monster.K9)).getBukkitEntity();
            K9Equipment.set((OfflinePlayer)player, k9, false);
            player.playSound(k9.getLocation(), "k9", 1.0f, 1.0f);
            this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)k9, EntityType.HUSK, Monster.K9, location));
        }
    }
}

