/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.sea_devils;

import java.util.Collection;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import me.eccentric_nz.tardisweepingangels.utils.WorldGuardChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldProcessor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SeaDevilRunnable
implements Runnable {
    private final TARDIS plugin;
    private final int spawn_rate;

    public SeaDevilRunnable(TARDIS plugin) {
        this.plugin = plugin;
        this.spawn_rate = plugin.getMonstersConfig().getInt("spawn_rate.how_many");
    }

    @Override
    public void run() {
        this.plugin.getServer().getWorlds().forEach(w -> {
            String name = WorldProcessor.sanitiseName(w.getName());
            if (this.plugin.getMonstersConfig().getInt("sea_devils.worlds." + name) > 0) {
                int devil = 0;
                Collection drowned = w.getEntitiesByClass(Drowned.class);
                for (Drowned d : drowned) {
                    PersistentDataContainer pdc = d.getPersistentDataContainer();
                    if (!pdc.has(TARDISWeepingAngels.DEVIL, PersistentDataType.INTEGER)) continue;
                    ++devil;
                }
                if (devil < this.plugin.getMonstersConfig().getInt("sea_devils.worlds." + name)) {
                    for (int i = 0; i < this.spawn_rate; ++i) {
                        this.spawnSeaDevil((World)w);
                    }
                }
            }
        });
    }

    private void spawnSeaDevil(World world) {
        int players = world.getPlayers().size();
        if (players == 0) {
            return;
        }
        Chunk[] chunks = world.getLoadedChunks();
        if (chunks.length > 0) {
            Chunk chunk = chunks[TARDISConstants.RANDOM.nextInt(chunks.length)];
            int x = chunk.getX() * 16 + TARDISConstants.RANDOM.nextInt(16);
            int z = chunk.getZ() * 16 + TARDISConstants.RANDOM.nextInt(16);
            int y = world.getHighestBlockYAt(x, z);
            Location l = new Location(world, (double)x, (double)(y + 1), (double)z);
            if (this.plugin.isWorldGuardOnServer() && !WorldGuardChecker.canSpawn(l)) {
                return;
            }
            LivingEntity devil = new MonsterSpawner().create(l, Monster.SEA_DEVIL);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                new Equipper(Monster.SEA_DEVIL, devil, false).setHelmetAndInvisibility();
                this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)devil, EntityType.DROWNED, Monster.SEA_DEVIL, l));
            }, 5L);
        }
    }
}

