/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.BiomeLookup;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISDiskCraftListener
implements Listener {
    private final TARDIS plugin;
    private final List<InventoryAction> actions = new ArrayList<InventoryAction>();

    public TARDISDiskCraftListener(TARDIS plugin) {
        this.plugin = plugin;
        this.actions.add(InventoryAction.PLACE_ALL);
        this.actions.add(InventoryAction.PLACE_ONE);
        this.actions.add(InventoryAction.PLACE_SOME);
        this.actions.add(InventoryAction.SWAP_WITH_CURSOR);
    }

    @EventHandler(ignoreCancelled=true)
    public void onCraftBiomePresetDisk(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory inv = event.getInventory();
        int slot = event.getRawSlot();
        if (!inv.getType().equals((Object)InventoryType.WORKBENCH) || slot > 9 || !this.actions.contains(event.getAction())) {
            return;
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (!this.checkSlots(inv)) {
                return;
            }
            List<ItemStack> items = this.getOtherItems(inv);
            if (inv.contains(Material.MUSIC_DISC_CAT)) {
                ItemStack is = inv.getItem(inv.first(Material.MUSIC_DISC_CAT));
                if (is == null || !is.hasItemMeta()) {
                    return;
                }
                ItemMeta im = is.getItemMeta();
                if (!(im.hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Biome Storage Disk") && im.hasLore())) {
                    return;
                }
                List lore = im.lore();
                if (!ComponentUtils.stripColour((Component)lore.getFirst()).equals("Blank")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_BLANK_BIOME");
                    return;
                }
                ArrayList<TextComponent> disk_lore = new ArrayList<TextComponent>();
                Material lookup = items.getFirst().getType();
                Biome biome = BiomeLookup.MATERIALS.get(lookup);
                if (biome != null) {
                    disk_lore.add(Component.text((String)biome.toString()));
                }
                if (disk_lore.isEmpty()) {
                    return;
                }
                ItemStack disk = ItemStack.of((Material)Material.MUSIC_DISC_CAT, (int)1);
                ItemMeta dim = disk.getItemMeta();
                dim.displayName((Component)Component.text((String)"Biome Storage Disk"));
                dim.lore(disk_lore);
                disk.setItemMeta(dim);
                inv.setItem(0, disk);
                player.updateInventory();
            } else {
                ItemStack is = inv.getItem(inv.first(Material.MUSIC_DISC_MALL));
                if (is == null || !is.hasItemMeta()) {
                    return;
                }
                ItemMeta im = is.getItemMeta();
                if (!(im.hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Preset Storage Disk") && im.hasLore())) {
                    return;
                }
                List lore = im.lore();
                if (!ComponentUtils.stripColour((Component)lore.getFirst()).equals("Blank")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_BLANK_PRESET");
                    return;
                }
                if (items.isEmpty()) {
                    return;
                }
                Material m = items.getFirst().getType();
                String preset = "";
                if (ChameleonPreset.getPreset(m) != null) {
                    preset = ChameleonPreset.getPreset(m).toString();
                }
                if (preset.isEmpty()) {
                    return;
                }
                ItemStack disk = ItemStack.of((Material)Material.MUSIC_DISC_MALL, (int)1);
                ItemMeta dim = disk.getItemMeta();
                dim.displayName((Component)Component.text((String)"Preset Storage Disk"));
                dim.lore(List.of(Component.text((String)preset)));
                disk.setItemMeta(dim);
                inv.setItem(0, disk);
                player.updateInventory();
            }
        }, 3L);
    }

    private boolean checkSlots(Inventory inv) {
        boolean check = false;
        int count = 0;
        for (int i = 1; i < 10; ++i) {
            if (inv.getItem(i) == null || inv.getItem(i).getType().isAir()) continue;
            ++count;
        }
        if ((inv.contains(Material.MUSIC_DISC_CAT) || inv.contains(Material.MUSIC_DISC_MALL)) && count > 1) {
            check = true;
        }
        return check;
    }

    private List<ItemStack> getOtherItems(Inventory inv) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack is : inv.getContents()) {
            Material m;
            if (is == null || (m = is.getType()).equals((Object)Material.MUSIC_DISC_CAT) || m.equals((Object)Material.MUSIC_DISC_MALL) || m.isAir()) continue;
            items.add(is);
        }
        return items;
    }
}

