/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.StandbyData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightPrefs;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Consoles;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import me.eccentric_nz.TARDIS.schematic.ResultSetArchive;

public class ResultSetStandby {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public ResultSetStandby(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Integer, StandbyData> onStandby() {
        HashMap<Integer, StandbyData> ids;
        block25: {
            ids = new HashMap<Integer, StandbyData>();
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT tardis_id, artron_level, chameleon_preset, size, hidden, lights_on, uuid FROM " + this.prefix + "tardis WHERE powered_on = 1 AND abandoned = 0";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                rs = statement.executeQuery();
                if (!rs.isBeforeFirst()) break block25;
                while (rs.next()) {
                    ChameleonPreset preset;
                    try {
                        preset = rs.getString("chameleon_preset").startsWith("ITEM") ? ChameleonPreset.ITEM : ChameleonPreset.valueOf(rs.getString("chameleon_preset"));
                    }
                    catch (IllegalArgumentException e) {
                        preset = ChameleonPreset.FACTORY;
                    }
                    ids.put(rs.getInt("tardis_id"), switch (rs.getString("size")) {
                        case "JUNK" -> new StandbyData(Integer.MAX_VALUE, UUID.fromString(rs.getString("uuid")), false, false, ChameleonPreset.JUNK, TardisLight.TENTH);
                        case "ARCHIVE" -> {
                            HashMap<String, Object> wherea = new HashMap<String, Object>();
                            wherea.put("uuid", rs.getString("uuid"));
                            wherea.put("use", 1);
                            ResultSetArchive rsa = new ResultSetArchive(this.plugin, wherea);
                            TardisLight lightType = TardisLight.LAMP;
                            if (rsa.resultSet()) {
                                lightType = rsa.getArchive().getLight();
                            }
                            yield new StandbyData(Integer.MAX_VALUE, UUID.fromString(rs.getString("uuid")), rs.getBoolean("hidden"), rs.getBoolean("lights_on"), preset, lightType);
                        }
                        default -> {
                            ResultSetLightPrefs rsp = new ResultSetLightPrefs(this.plugin);
                            TardisLight light = rsp.fromID(rs.getInt("tardis_id")) ? rsp.getLight() : Consoles.getBY_NAMES().get(rs.getString("size")).getLights();
                            yield new StandbyData(rs.getInt("artron_level"), UUID.fromString(rs.getString("uuid")), rs.getBoolean("hidden"), rs.getBoolean("lights_on"), preset, light);
                        }
                    });
                }
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for standby! " + e.getMessage());
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing standby! " + e.getMessage());
                }
            }
        }
        return ids;
    }
}

