/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisshop.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.tardisshop.TARDISShopItem;

public class InsertShopItem {
    private final TARDIS plugin;
    private final String prefix;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();

    public InsertShopItem(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TARDISShopItem addNamedItem(String item, double cost) {
        Statement ps = null;
        ResultSet idRS = null;
        String query = "INSERT INTO " + this.prefix + "items (item, cost) VALUES (?, ?)";
        try {
            ps = this.service.isMySQL() ? this.connection.prepareStatement(query, 1) : this.connection.prepareStatement(query + " RETURNING item_id");
            ps.setString(1, item);
            ps.setDouble(2, cost);
            if (this.service.isMySQL()) {
                ps.executeUpdate();
                idRS = ps.getGeneratedKeys();
            } else {
                idRS = ps.executeQuery();
            }
            int id = idRS.next() ? idRS.getInt(1) : -1;
            TARDISShopItem tARDISShopItem = new TARDISShopItem(id, item, null, cost);
            return tARDISShopItem;
        }
        catch (SQLException e) {
            this.plugin.debug("Insert error for items! " + e.getMessage());
        }
        finally {
            try {
                if (idRS != null) {
                    idRS.close();
                }
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing items! " + e.getMessage());
            }
        }
        return null;
    }
}

