/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.config.TARDISConfigCommand;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.listeners.TARDISRenderRoomListener;
import me.eccentric_nz.TARDIS.move.TARDISDoorListener;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.rooms.TARDISCondenserData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class TARDISGeneralInstanceKeeper {
    private final HashMap<String, Double[]> gravityEastList = new HashMap();
    private final HashMap<String, Double[]> gravityNorthList = new HashMap();
    private final HashMap<String, Double[]> gravitySouthList = new HashMap();
    private final HashMap<String, Double[]> gravityUpList = new HashMap();
    private final HashMap<String, Double[]> gravityWestList = new HashMap();
    private final Set<String> gravityDownList = new HashSet<String>();
    private final HashMap<String, Integer> protectBlockMap = new HashMap();
    private final HashMap<String, String> sign_lookup;
    private final HashMap<UUID, TARDISCondenserData> roomCondenserData = new HashMap();
    private final Set<Material> transparent;
    private final Set<Block> artronFurnaces = new HashSet<Block>();
    private final List<BlockFace> blockFaces = List.of(BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH, BlockFace.EAST);
    private final List<BlockFace> faces = List.of(BlockFace.NORTH, BlockFace.WEST, BlockFace.SOUTH, BlockFace.EAST);
    private final List<BlockFace> surrounding = List.of(BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST);
    private final Set<Location> rechargers = new HashSet<Location>();
    private final List<Material> goodNether = new ArrayList<Material>(){
        {
            this.addAll(Tag.NETHER_CARVER_REPLACEABLES.getValues());
            this.add(Material.GLOWSTONE);
            this.add(Material.NETHER_BRICK);
            this.add(Material.NETHER_BRICK_FENCE);
            this.add(Material.NETHER_BRICK_STAIRS);
        }
    };
    private final List<String> roomArgs;
    private final Set<String> sonicLamps = new HashSet<String>();
    private final Set<String> sonicPistons = new HashSet<String>();
    private final Set<String> sonicRails = new HashSet<String>();
    private final Set<String> sonicWires = new HashSet<String>();
    private final Set<UUID> junkTravellers = new HashSet<UUID>();
    private final Set<UUID> timeRotors = new HashSet<UUID>();
    private final TARDIS plugin;
    private final TARDISDoorListener doorListener;
    private final YamlConfiguration pluginYAML;
    private boolean junkTravelling = false;
    private List<String> quotes = new ArrayList<String>();
    private Location junkDestination = null;
    private TARDISConfigCommand tardisConfigCommand;
    private TARDISRenderRoomListener rendererListener;

    TARDISGeneralInstanceKeeper(TARDIS plugin) {
        this.plugin = plugin;
        this.roomArgs = this.buildRoomArgs();
        this.transparent = this.buildTransparent();
        this.doorListener = new TARDISDoorListener(plugin);
        this.sign_lookup = this.buildSignLookup();
        this.setRechargers();
        InputStream is = plugin.getResource("plugin.yml");
        InputStreamReader reader = new InputStreamReader(is);
        this.pluginYAML = new YamlConfiguration();
        try {
            this.pluginYAML.load((Reader)reader);
        }
        catch (IOException | InvalidConfigurationException ex) {
            plugin.getLogger().log(Level.SEVERE, null, ex);
        }
    }

    public List<String> getQuotes() {
        return this.quotes;
    }

    public void setQuotes(ArrayList<String> quotes) {
        this.quotes = quotes;
    }

    public Set<Block> getArtronFurnaces() {
        return this.artronFurnaces;
    }

    public List<BlockFace> getFaces() {
        return this.faces;
    }

    public List<BlockFace> getShuffledFaces() {
        ArrayList<BlockFace> shuffled = new ArrayList<BlockFace>(this.faces);
        Collections.shuffle(shuffled);
        return shuffled;
    }

    public List<BlockFace> getBlockFaces() {
        return this.blockFaces;
    }

    public List<BlockFace> getSurrounding() {
        return this.surrounding;
    }

    public List<Material> getGoodNether() {
        return this.goodNether;
    }

    public HashMap<String, Double[]> getGravityUpList() {
        return this.gravityUpList;
    }

    public Set<String> getGravityDownList() {
        return this.gravityDownList;
    }

    public HashMap<String, Double[]> getGravityNorthList() {
        return this.gravityNorthList;
    }

    public HashMap<String, Double[]> getGravityWestList() {
        return this.gravityWestList;
    }

    public HashMap<String, Double[]> getGravitySouthList() {
        return this.gravitySouthList;
    }

    public HashMap<String, Double[]> getGravityEastList() {
        return this.gravityEastList;
    }

    public HashMap<String, Integer> getProtectBlockMap() {
        return this.protectBlockMap;
    }

    public HashMap<String, String> getSign_lookup() {
        return this.sign_lookup;
    }

    public HashMap<UUID, TARDISCondenserData> getRoomCondenserData() {
        return this.roomCondenserData;
    }

    public Set<UUID> getTimeRotors() {
        return this.timeRotors;
    }

    public TARDISConfigCommand getTardisConfigCommand() {
        return this.tardisConfigCommand;
    }

    void setTardisConfigCommand(TARDISConfigCommand tardisConfigCommand) {
        this.tardisConfigCommand = tardisConfigCommand;
    }

    public TARDISDoorListener getDoorListener() {
        return this.doorListener;
    }

    public TARDISRenderRoomListener getRendererListener() {
        return this.rendererListener;
    }

    void setRendererListener(TARDISRenderRoomListener rendererListener) {
        this.rendererListener = rendererListener;
    }

    public List<String> getRoomArgs() {
        return this.roomArgs;
    }

    public Set<Material> getTransparent() {
        return this.transparent;
    }

    public Set<String> getSonicLamps() {
        return this.sonicLamps;
    }

    public Set<String> getSonicPistons() {
        return this.sonicPistons;
    }

    public Set<String> getSonicRails() {
        return this.sonicRails;
    }

    public Set<String> getSonicWires() {
        return this.sonicWires;
    }

    public Set<Location> getRechargers() {
        return this.rechargers;
    }

    public YamlConfiguration getPluginYAML() {
        return this.pluginYAML;
    }

    public boolean isJunkTravelling() {
        return this.junkTravelling;
    }

    public void setJunkTravelling(boolean junkTravelling) {
        this.junkTravelling = junkTravelling;
    }

    public Location getJunkDestination() {
        return this.junkDestination;
    }

    public void setJunkDestination(Location junkDestination) {
        this.junkDestination = junkDestination;
    }

    public Set<UUID> getJunkTravellers() {
        return this.junkTravellers;
    }

    private void setRechargers() {
        if (this.plugin.getConfig().isConfigurationSection("rechargers")) {
            Set therechargers = this.plugin.getConfig().getConfigurationSection("rechargers").getKeys(false);
            therechargers.forEach(s -> {
                World w = TARDISAliasResolver.getWorldFromAlias(this.plugin.getConfig().getString("rechargers." + s + ".world"));
                if (w != null) {
                    int x = this.plugin.getConfig().getInt("rechargers." + s + ".x");
                    int y = this.plugin.getConfig().getInt("rechargers." + s + ".y");
                    int z = this.plugin.getConfig().getInt("rechargers." + s + ".z");
                    Location rc_loc = new Location(w, (double)x, (double)y, (double)z);
                    this.rechargers.add(rc_loc);
                }
            });
        }
    }

    private Set<Material> buildTransparent() {
        HashSet<Material> trans = new HashSet<Material>();
        trans.add(Material.END_ROD);
        trans.add(Material.IRON_BARS);
        trans.add(Material.MOSS_CARPET);
        trans.add(Material.PINK_PETALS);
        trans.add(Material.REDSTONE_WIRE);
        trans.addAll(Tag.CROPS.getValues());
        trans.addAll(Tag.PRESSURE_PLATES.getValues());
        trans.addAll(Tag.REPLACEABLE.getValues());
        trans.addAll(Tag.SAPLINGS.getValues());
        trans.addAll(Tag.SMALL_FLOWERS.getValues());
        trans.addAll(Tag.FLOWERS.getValues());
        trans.addAll(Tag.WOOL_CARPETS.getValues());
        return trans;
    }

    private List<String> buildRoomArgs() {
        ArrayList<String> rooms = new ArrayList<String>();
        this.plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false).forEach(r -> {
            if (this.plugin.getRoomsConfig().getBoolean("rooms." + r + ".enabled")) {
                rooms.add((String)r);
            }
        });
        return rooms;
    }

    private HashMap<String, String> buildSignLookup() {
        HashMap<String, String> lookup = new HashMap<String, String>();
        for (ChameleonPreset p : ChameleonPreset.values()) {
            if (p.getFirstLine().isEmpty() || lookup.containsKey(p.getFirstLine())) continue;
            lookup.put(p.getFirstLine(), p.getSecondLine());
        }
        return lookup;
    }
}

