/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.bStats;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.bStats.ARSRoomCounts;
import me.eccentric_nz.TARDIS.bStats.BedrockCount;
import me.eccentric_nz.TARDIS.bStats.ChameleonPresets;
import me.eccentric_nz.TARDIS.bStats.CondenserCounts;
import me.eccentric_nz.TARDIS.bStats.ConsoleTypes;
import me.eccentric_nz.TARDIS.bStats.DependentPlugins;
import me.eccentric_nz.TARDIS.bStats.Metrics;
import me.eccentric_nz.TARDIS.bStats.Modules;
import me.eccentric_nz.TARDIS.bStats.TardisCount;
import me.eccentric_nz.TARDIS.bStats.TravelTypes;

public class TARDISStats {
    private final TARDIS plugin;
    private final int pluginId = 11698;

    public TARDISStats(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void startMetrics() {
        Metrics metrics = new Metrics(this.plugin, 11698);
        metrics.addCustomChart(new Metrics.SingleLineChart("bedrock_users", () -> new BedrockCount(this.plugin).getCount()));
        metrics.addCustomChart(new Metrics.AdvancedPie("console_types", () -> new ConsoleTypes(this.plugin).getMap()));
        metrics.addCustomChart(new Metrics.AdvancedPie("chameleon_presets", () -> new ChameleonPresets(this.plugin).getMap()));
        metrics.addCustomChart(new Metrics.AdvancedPie("travel_types", () -> new TravelTypes(this.plugin).getMap()));
        metrics.addCustomChart(new Metrics.SimplePie("using_tips", () -> !this.plugin.getConfig().getBoolean("creation.create_worlds", false) ? "true" : "false"));
        metrics.addCustomChart(new Metrics.SimplePie("end_travel", () -> this.plugin.getConfig().getString("travel.the_end", "true")));
        metrics.addCustomChart(new Metrics.SimplePie("nether_travel", () -> this.plugin.getConfig().getString("travel.nether", "true")));
        metrics.addCustomChart(new Metrics.SingleLineChart("number_of_tardises", () -> new TardisCount(this.plugin).getCount(0)));
        metrics.addCustomChart(new Metrics.SingleLineChart("abandoned_tardises", () -> new TardisCount(this.plugin).getCount(1)));
        metrics.addCustomChart(new Metrics.AdvancedPie("condensed_blocks", () -> new CondenserCounts(this.plugin).getCounts()));
        ARSRoomCounts arsRoomCounts = new ARSRoomCounts(this.plugin);
        metrics.addCustomChart(new Metrics.AdvancedPie("rooms", arsRoomCounts::getRoomCounts));
        metrics.addCustomChart(new Metrics.SimplePie("median_rooms_per_tardis", arsRoomCounts::getMedian));
        metrics.addCustomChart(new Metrics.SimplePie("difficulty_circuits", () -> this.plugin.getConfig().getString("difficulty.circuits", "false")));
        metrics.addCustomChart(new Metrics.SimplePie("difficulty_disks", () -> this.plugin.getConfig().getString("difficulty.disks", "false")));
        metrics.addCustomChart(new Metrics.SimplePie("junk_tardis", () -> this.plugin.getConfig().getString("junk.enabled", "true")));
        metrics.addCustomChart(new Metrics.AdvancedPie("modules", () -> new Modules(this.plugin).getMap()));
        metrics.addCustomChart(new Metrics.AdvancedPie("dependent_plugins", () -> new DependentPlugins(this.plugin).getMap()));
    }
}

