/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.travel;

import com.google.common.collect.ImmutableList;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.commands.travel.TerraBiomes;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import org.bukkit.block.Biome;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TARDISTravelTabComplete
extends TARDISCompleter
implements TabCompleter {
    private final List<String> ROOT_SUBS = new ArrayList<String>();
    private final Set<String> BIOME_SUBS = new HashSet<String>();
    private final List<String> AREA_SUBS = new ArrayList<String>();
    private final List<String> STRUCTURE_SUBS;

    public TARDISTravelTabComplete(TARDIS plugin) {
        for (Biome bi : RegistryAccess.registryAccess().getRegistry(RegistryKey.BIOME)) {
            if (bi.equals((Object)Biome.THE_VOID)) continue;
            this.BIOME_SUBS.add(bi.toString());
        }
        if (TARDIS.plugin.getServer().getPluginManager().isPluginEnabled("TerraformGenerator")) {
            this.BIOME_SUBS.addAll(new TerraBiomes().get());
        }
        this.ROOT_SUBS.addAll(List.of("home", "biome", "save", "dest", "area", "back", "player", "cave", "village", "structure", "random", "cancel", "costs", "stop"));
        this.ROOT_SUBS.addAll(plugin.getTardisAPI().getWorlds());
        ResultSetAreas rsa = new ResultSetAreas(plugin, null, false, true);
        if (rsa.resultSet()) {
            this.AREA_SUBS.addAll(rsa.getNames());
        }
        this.STRUCTURE_SUBS = List.of("PILLAGER_OUTPOST", "MINESHAFT", "MINESHAFT_MESA", "MANSION", "JUNGLE_PYRAMID", "DESERT_PYRAMID", "IGLOO", "SHIPWRECK", "SHIPWRECK_BEACHED", "SWAMP_HUT", "STRONGHOLD", "MONUMENT", "OCEAN_RUIN_COLD", "OCEAN_RUIN_WARM", "FORTRESS", "NETHER_FOSSIL", "END_CITY", "BURIED_TREASURE", "BASTION_REMNANT", "VILLAGE_PLAINS", "VILLAGE_DESERT", "VILLAGE_SAVANNA", "VILLAGE_SNOWY", "VILLAGE_TAIGA", "RUINED_PORTAL", "RUINED_PORTAL_DESERT", "RUINED_PORTAL_JUNGLE", "RUINED_PORTAL_SWAMP", "RUINED_PORTAL_MOUNTAIN", "RUINED_PORTAL_OCEAN", "RUINED_PORTAL_NETHER", "ANCIENT_CITY", "TRAIL_RUINS");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            List<String> part = this.partial(args[0], this.ROOT_SUBS);
            return !part.isEmpty() ? part : null;
        }
        if (args.length == 2) {
            String sub;
            switch (sub = args[0].toLowerCase(Locale.ROOT)) {
                case "area": {
                    return this.partial(lastArg, this.AREA_SUBS);
                }
                case "biome": {
                    return this.partial(lastArg, this.BIOME_SUBS);
                }
                case "village": 
                case "structure": {
                    return this.partial(lastArg, this.STRUCTURE_SUBS);
                }
                case "player": {
                    return null;
                }
            }
        }
        return ImmutableList.of();
    }
}

