/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ResultSetScreen {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final int tardis_id;
    private final String prefix;
    private String preset;
    private String world;
    private String location;
    private String x;
    private String y;
    private String z;
    private String artronLevel;

    public ResultSetScreen(TARDIS plugin, int tardis_id) {
        this.plugin = plugin;
        this.tardis_id = tardis_id;
        this.prefix = this.plugin.getPrefix();
    }

    public void locationAsync(ResultSetControlCallback callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            boolean hasResult = this.locationData();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onDone(hasResult, this));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean locationData() {
        block16: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT " + this.prefix + "current.* FROM " + this.prefix + "tardis, " + this.prefix + "current WHERE " + this.prefix + "tardis.tardis_id = ? AND " + this.prefix + "tardis.abandoned = 0 AND " + this.prefix + "tardis.tardis_id = " + this.prefix + "current.tardis_id";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, this.tardis_id);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    rs.next();
                    this.world = rs.getString("world");
                    this.x = rs.getString("x");
                    this.y = rs.getString("y");
                    this.z = rs.getString("z");
                    this.location = this.x + ", " + this.y + ", " + this.z;
                    break block16;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for console tables! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing console tables! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public void artronAsync(ResultSetControlCallback callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            boolean hasResult = this.artronData();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onDone(hasResult, this));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean artronData() {
        block16: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT artron_level, chameleon_preset FROM " + this.prefix + "tardis WHERE tardis_id = ? AND abandoned = 0";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, this.tardis_id);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    rs.next();
                    this.artronLevel = rs.getString("artron_level");
                    this.preset = rs.getString("chameleon_preset");
                    break block16;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for controls table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing controls table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public String getPreset() {
        return this.preset;
    }

    public String getWorld() {
        return this.world;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getZ() {
        return this.z;
    }

    public String getArtronLevel() {
        return this.artronLevel;
    }

    public static interface ResultSetControlCallback {
        public void onDone(boolean var1, ResultSetScreen var2);
    }
}

