/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lazarus.disguise;

import com.destroystokyo.paper.SkinParts;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.skins.SkinFetcher;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;

public class EmergencyProgramOneSpawner {
    private final Player player;
    private final Location location;
    private Mannequin npc = null;

    public EmergencyProgramOneSpawner(Player player, Location location) {
        this.player = player;
        this.location = location;
    }

    public void create() {
        SkinFetcher getter = new SkinFetcher(TARDIS.plugin, this.player.getUniqueId());
        getter.fetchAsync((hasResult, fetched) -> {
            JsonObject properties;
            if (hasResult && (properties = fetched.getSkin()) != null) {
                GameProfile gameProfile = new GameProfile(UUID.randomUUID(), this.player.getName());
                String value = properties.get("value").getAsString();
                String signature = properties.get("signature").getAsString();
                gameProfile.properties().removeAll((Object)"textures");
                gameProfile.properties().put((Object)"textures", (Object)new Property("textures", value, signature));
                ResolvableProfile profile = ResolvableProfile.resolvableProfile((PlayerProfile)this.player.getPlayerProfile());
                World world = this.location.getWorld();
                this.npc = (Mannequin)world.spawnEntity(this.location, EntityType.MANNEQUIN);
                this.npc.setHealth(20.0);
                this.npc.setProfile(profile);
                this.npc.setSkinParts((SkinParts)SkinParts.allParts());
                this.npc.setImmovable(true);
                this.npc.setInvulnerable(true);
                EntityEquipment equipment = this.npc.getEquipment();
                equipment.setBoots(this.player.getInventory().getBoots());
                equipment.setLeggings(this.player.getInventory().getLeggings());
                equipment.setChestplate(this.player.getInventory().getChestplate());
                equipment.setHelmet(this.player.getInventory().getHelmet());
                equipment.setItemInMainHand(this.player.getInventory().getItemInMainHand());
                equipment.setItemInOffHand(this.player.getInventory().getItemInOffHand());
            }
        });
    }

    public Mannequin getMannequin() {
        return this.npc;
    }
}

