/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISEntityTracker;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class TARDISRenderRoomListener
implements Listener {
    private final TARDIS plugin;

    public TARDISRenderRoomListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getTrackerKeeper().getRenderRoomOccupants().contains(player.getUniqueId())) {
            event.setCancelled(true);
            if (event.getHand().equals((Object)EquipmentSlot.HAND) && (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) || event.getAction().equals((Object)Action.RIGHT_CLICK_AIR))) {
                this.transmat(player);
                player.updateInventory();
            }
        }
    }

    public void transmat(Player p) {
        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "TRANSMAT");
        HashMap<String, Object> wherep = new HashMap<String, Object>();
        wherep.put("uuid", p.getUniqueId().toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherep, false);
        if (rst.resultSet()) {
            int id = rst.getTardis_id();
            HashMap<String, Object> whered = new HashMap<String, Object>();
            whered.put("tardis_id", id);
            whered.put("door_type", 1);
            ResultSetDoors rsd = new ResultSetDoors(this.plugin, whered, false);
            if (rsd.resultSet()) {
                COMPASS d = rsd.getDoor_direction();
                Location tp_loc = TARDISStaticLocationGetters.getLocationFromDB(rsd.getDoor_location());
                int getx = tp_loc.getBlockX();
                int getz = tp_loc.getBlockZ();
                switch (d) {
                    case NORTH: {
                        tp_loc.setX((double)getx + 0.5);
                        tp_loc.setZ((double)getz - 0.5);
                        break;
                    }
                    case EAST: {
                        tp_loc.setX((double)getx + 1.5);
                        tp_loc.setZ((double)getz + 0.5);
                        break;
                    }
                    case SOUTH: {
                        tp_loc.setX((double)getx + 0.5);
                        tp_loc.setZ((double)getz + 1.5);
                        break;
                    }
                    default: {
                        tp_loc.setX((double)getx - 0.5);
                        tp_loc.setZ((double)getz + 0.5);
                    }
                }
                tp_loc.setPitch(p.getLocation().getPitch());
                tp_loc.setYaw(p.getLocation().getYaw());
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    p.playSound(tp_loc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                    p.teleport(tp_loc);
                    this.plugin.getTrackerKeeper().getRenderRoomOccupants().remove(p.getUniqueId());
                    if (this.plugin.getTrackerKeeper().getRenderedNPCs().containsKey(p.getUniqueId())) {
                        new TARDISEntityTracker(this.plugin).removeNPCs(p.getUniqueId());
                    }
                }, 10L);
            } else {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "TRANSMAT_NO_CONSOLE");
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "TRANSMAT_NO_TARDIS");
        }
    }
}

